/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.hazelcast.leader;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.cluster.leader.Candidate;
import org.springframework.cloud.cluster.leader.Context;
import org.springframework.cloud.cluster.leader.event.DefaultLeaderEventPublisher;
import org.springframework.cloud.cluster.leader.event.LeaderEventPublisher;
import org.springframework.context.Lifecycle;
import org.springframework.util.Assert;

public class LeaderInitiator
implements Lifecycle,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(LeaderInitiator.class);
    private final HazelcastInstance client;
    private final Candidate candidate;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Hazelcast leadership");
            thread.setDaemon(true);
            return thread;
        }
    });
    private volatile Future<Void> future;
    private volatile IMap<String, String> mapLocks;
    private volatile boolean running;
    private volatile LeaderEventPublisher leaderEventPublisher = new DefaultLeaderEventPublisher();

    public LeaderInitiator(HazelcastInstance client, Candidate candidate) {
        this.client = client;
        this.candidate = candidate;
    }

    public synchronized void start() {
        if (!this.running) {
            this.mapLocks = this.client.getMap("spring-cloud-leader");
            this.running = true;
            this.future = this.executorService.submit(new Initiator());
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            this.future.cancel(true);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
        this.executorService.shutdown();
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        Assert.notNull((Object)leaderEventPublisher);
        this.leaderEventPublisher = leaderEventPublisher;
    }

    class HazelcastContext
    implements Context {
        HazelcastContext() {
        }

        public boolean isLeader() {
            return LeaderInitiator.this.mapLocks != null && LeaderInitiator.this.mapLocks.isLocked((Object)LeaderInitiator.this.candidate.getRole());
        }

        public void yield() {
            if (LeaderInitiator.this.future != null) {
                LeaderInitiator.this.future.cancel(true);
            }
        }

        public String toString() {
            return String.format("HazelcastContext{role=%s, id=%s, isLeader=%s}", LeaderInitiator.this.candidate.getRole(), LeaderInitiator.this.candidate.getId(), this.isLeader());
        }
    }

    class Initiator
    implements Callable<Void> {
        Initiator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            Assert.state((LeaderInitiator.this.mapLocks != null ? 1 : 0) != 0);
            HazelcastContext context = new HazelcastContext();
            String role = LeaderInitiator.this.candidate.getRole();
            boolean locked = false;
            while (LeaderInitiator.this.running) {
                try {
                    locked = LeaderInitiator.this.mapLocks.tryLock((Object)role, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                    if (!locked) continue;
                    LeaderInitiator.this.mapLocks.put((Object)role, (Object)LeaderInitiator.this.candidate.getId());
                    LeaderInitiator.this.leaderEventPublisher.publishOnGranted((Object)LeaderInitiator.this, (Context)context, LeaderInitiator.this.candidate.getRole());
                    LeaderInitiator.this.candidate.onGranted((Context)context);
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (Exception e) {
                    logger.warn("Exception caught", (Throwable)e);
                }
                finally {
                    if (!locked) continue;
                    LeaderInitiator.this.mapLocks.remove((Object)role);
                    LeaderInitiator.this.mapLocks.unlock((Object)role);
                    LeaderInitiator.this.candidate.onRevoked((Context)context);
                    LeaderInitiator.this.leaderEventPublisher.publishOnRevoked((Object)LeaderInitiator.this, (Context)context, LeaderInitiator.this.candidate.getRole());
                    locked = false;
                }
            }
            return null;
        }
    }
}

