/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cluster.etcd.leader;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import mousio.etcd4j.EtcdClient;
import mousio.etcd4j.responses.EtcdException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cloud.cluster.leader.Candidate;
import org.springframework.cloud.cluster.leader.Context;
import org.springframework.cloud.cluster.leader.event.DefaultLeaderEventPublisher;
import org.springframework.cloud.cluster.leader.event.LeaderEventPublisher;
import org.springframework.context.Lifecycle;
import org.springframework.util.Assert;

public class LeaderInitiator
implements Lifecycle,
InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(LeaderInitiator.class);
    private static final int TTL = 10;
    private static final int HEART_BEAT_SLEEP = 5;
    private static final String DEFAULT_NAMESPACE = "spring-cloud";
    private final EtcdClient client;
    private final Candidate candidate;
    private final ExecutorService leaderExecutorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Etcd-Leadership");
            thread.setDaemon(true);
            return thread;
        }
    });
    private final ExecutorService workerExecutorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "Etcd-Leadership-Worker");
            thread.setDaemon(true);
            return thread;
        }
    });
    private volatile boolean isLeader = false;
    private volatile boolean relinquishLeadership = false;
    private volatile Future<Void> initiatorFuture;
    private volatile Future<Void> workerFuture;
    private volatile boolean running;
    private volatile LeaderEventPublisher leaderEventPublisher = new DefaultLeaderEventPublisher();
    private final EtcdContext context;
    private final String baseEtcdPath;

    public LeaderInitiator(EtcdClient client, Candidate candidate, String namespace) {
        this.client = client;
        this.candidate = candidate;
        this.context = new EtcdContext();
        this.baseEtcdPath = (namespace == null ? DEFAULT_NAMESPACE : namespace) + "/" + candidate.getRole();
    }

    public synchronized void start() {
        if (!this.running) {
            this.running = true;
            this.initiatorFuture = this.leaderExecutorService.submit(new Initiator());
        }
    }

    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            this.initiatorFuture.cancel(true);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public void afterPropertiesSet() throws Exception {
        this.start();
    }

    public void destroy() throws Exception {
        this.stop();
        this.workerExecutorService.shutdown();
        this.leaderExecutorService.shutdown();
        this.workerExecutorService.awaitTermination(30L, TimeUnit.SECONDS);
        this.leaderExecutorService.awaitTermination(30L, TimeUnit.SECONDS);
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        Assert.notNull((Object)leaderEventPublisher);
        this.leaderEventPublisher = leaderEventPublisher;
    }

    private void notifyGranted() {
        this.isLeader = true;
        this.leaderEventPublisher.publishOnGranted((Object)this, (Context)this.context, this.candidate.getRole());
        this.workerFuture = this.workerExecutorService.submit(new Worker());
    }

    private void notifyRevoked() throws InterruptedException {
        this.isLeader = false;
        this.leaderEventPublisher.publishOnRevoked((Object)this, (Context)this.context, this.candidate.getRole());
        this.workerFuture.cancel(true);
        try {
            this.workerFuture.get();
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (CancellationException e) {
        }
        catch (ExecutionException e) {
            logger.error("Exception thrown by candidate", e.getCause());
        }
    }

    private void tryDeleteCandidateEntry() {
        try {
            this.client.delete(this.baseEtcdPath).prevValue(this.candidate.getId()).send().get();
        }
        catch (EtcdException e) {
            logger.warn("Couldn't delete candidate's entry from etcd", (Throwable)e);
        }
        catch (IOException | TimeoutException e) {
            logger.warn("Couldn't access etcd", (Throwable)e);
        }
    }

    class EtcdContext
    implements Context {
        EtcdContext() {
        }

        public boolean isLeader() {
            return LeaderInitiator.this.isLeader;
        }

        public void yield() {
            if (LeaderInitiator.this.isLeader) {
                LeaderInitiator.this.relinquishLeadership = true;
            }
        }

        public String toString() {
            return String.format("EtcdContext{role=%s, id=%s, isLeader=%s}", LeaderInitiator.this.candidate.getRole(), LeaderInitiator.this.candidate.getId(), this.isLeader());
        }
    }

    class Initiator
    implements Callable<Void> {
        Initiator() {
        }

        @Override
        public Void call() throws InterruptedException {
            try {
                while (LeaderInitiator.this.running) {
                    if (LeaderInitiator.this.relinquishLeadership) {
                        this.relinquishLeadership();
                        LeaderInitiator.this.relinquishLeadership = false;
                    } else if (LeaderInitiator.this.isLeader) {
                        this.sendHeartBeat();
                    } else {
                        this.tryAcquire();
                    }
                    TimeUnit.SECONDS.sleep(5L);
                }
            }
            finally {
                if (LeaderInitiator.this.isLeader) {
                    this.relinquishLeadership();
                }
            }
            return null;
        }

        private void relinquishLeadership() throws InterruptedException {
            LeaderInitiator.this.tryDeleteCandidateEntry();
            LeaderInitiator.this.notifyRevoked();
        }

        private void sendHeartBeat() throws InterruptedException {
            try {
                LeaderInitiator.this.client.put(LeaderInitiator.this.baseEtcdPath, LeaderInitiator.this.candidate.getId()).ttl(Integer.valueOf(10)).prevValue(LeaderInitiator.this.candidate.getId()).send().get();
            }
            catch (EtcdException e) {
                LeaderInitiator.this.notifyRevoked();
            }
            catch (IOException | TimeoutException e) {
                logger.error("Couldn't access etcd, relinquishing leadership...", (Throwable)e);
                LeaderInitiator.this.notifyRevoked();
            }
        }

        private void tryAcquire() {
            try {
                LeaderInitiator.this.client.put(LeaderInitiator.this.baseEtcdPath, LeaderInitiator.this.candidate.getId()).ttl(Integer.valueOf(10)).prevExist(false).send().get();
                LeaderInitiator.this.notifyGranted();
            }
            catch (EtcdException etcdException) {
            }
            catch (IOException | TimeoutException e) {
                logger.warn("Couldn't access etcd", (Throwable)e);
            }
        }
    }

    class Worker
    implements Callable<Void> {
        Worker() {
        }

        @Override
        public Void call() throws InterruptedException {
            try {
                LeaderInitiator.this.candidate.onGranted((Context)LeaderInitiator.this.context);
                Thread.sleep(Long.MAX_VALUE);
            }
            finally {
                LeaderInitiator.this.relinquishLeadership = true;
                LeaderInitiator.this.candidate.onRevoked((Context)LeaderInitiator.this.context);
            }
            return null;
        }
    }
}

