/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;

public class SimpleDnsBasedDiscoveryClient
implements DiscoveryClient {
    private static final Logger log = LoggerFactory.getLogger(SimpleDnsBasedDiscoveryClient.class);
    private final ServiceIdToHostnameConverter serviceIdToHostnameConverter;

    public SimpleDnsBasedDiscoveryClient(CloudFoundryDiscoveryProperties properties, ServiceIdToHostnameConverter serviceIdToHostnameConverter) {
        this.serviceIdToHostnameConverter = serviceIdToHostnameConverter;
    }

    public SimpleDnsBasedDiscoveryClient(CloudFoundryDiscoveryProperties properties) {
        this(properties, serviceId -> serviceId + "." + properties.getInternalDomain());
    }

    public String description() {
        return "DNS Based CF Service Discovery Client";
    }

    public List<ServiceInstance> getInstances(String serviceId) {
        String hostname = this.serviceIdToHostnameConverter.toHostname(serviceId);
        try {
            ArrayList<ServiceInstance> serviceInstances = new ArrayList<ServiceInstance>();
            InetAddress[] addresses = InetAddress.getAllByName(hostname);
            if (addresses != null) {
                for (InetAddress address : addresses) {
                    DefaultServiceInstance serviceInstance = new DefaultServiceInstance(serviceId, address.getHostAddress(), 8080, false);
                    serviceInstances.add((ServiceInstance)serviceInstance);
                }
            }
            return serviceInstances;
        }
        catch (UnknownHostException e) {
            log.warn("{}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<String> getServices() {
        log.warn("getServices is not supported");
        return Collections.emptyList();
    }

    @FunctionalInterface
    public static interface ServiceIdToHostnameConverter {
        public String toHostname(String var1);
    }
}

