/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ServerList;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.cloudfoundry.CloudFoundryService;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryDiscoveryProperties;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryServerList;
import org.springframework.cloud.netflix.ribbon.RibbonClientName;
import org.springframework.cloud.netflix.ribbon.RibbonUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CloudFoundryRibbonClientConfiguration {
    @RibbonClientName
    private String serviceId;

    public CloudFoundryRibbonClientConfiguration() {
    }

    public CloudFoundryRibbonClientConfiguration(String svcId) {
        this.serviceId = svcId;
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerList<?> ribbonServerList(CloudFoundryService svc, IClientConfig config, CloudFoundryDiscoveryProperties properties) {
        CloudFoundryServerList cloudFoundryServerList = new CloudFoundryServerList(svc, properties);
        cloudFoundryServerList.initWithNiwsConfig(config);
        return cloudFoundryServerList;
    }

    @PostConstruct
    public void postConstruct() {
        RibbonUtils.initializeRibbonDefaults((String)this.serviceId);
    }
}

