/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cloudfoundry.discovery;

import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.AbstractServerList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cloudfoundry.client.lib.CloudFoundryClient;
import org.cloudfoundry.client.lib.domain.CloudApplication;
import org.springframework.cloud.cloudfoundry.discovery.CloudFoundryServer;

public class CloudFoundryServerList
extends AbstractServerList<CloudFoundryServer> {
    private static final Log log = LogFactory.getLog(CloudFoundryServerList.class);
    protected String serviceId;
    private final CloudFoundryClient cloudFoundryClient;

    public CloudFoundryServerList(CloudFoundryClient cloudFoundryClient) {
        this.cloudFoundryClient = cloudFoundryClient;
    }

    public void initWithNiwsConfig(IClientConfig iClientConfig) {
        this.serviceId = iClientConfig.getClientName();
    }

    public List<CloudFoundryServer> getInitialListOfServers() {
        return this.cloudFoundryServers();
    }

    public List<CloudFoundryServer> getUpdatedListOfServers() {
        return this.cloudFoundryServers();
    }

    protected List<CloudFoundryServer> cloudFoundryServers() {
        try {
            CloudApplication cloudApplications = this.cloudFoundryClient.getApplication(this.serviceId);
            return Collections.singletonList(new CloudFoundryServer(cloudApplications));
        }
        catch (Exception e) {
            log.warn((Object)("Cannot determine server list for " + this.serviceId + ": " + e.getClass() + "(" + e.getMessage() + ")"));
            return Collections.emptyList();
        }
    }
}

