/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cli.command.encrypt;

import java.util.Collection;
import joptsimple.OptionSet;
import org.springframework.boot.cli.command.OptionParsingCommand;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.cloud.cli.command.encrypt.BaseEncryptOptionHandler;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.StringUtils;

public class DecryptCommand
extends OptionParsingCommand {
    public DecryptCommand() {
        super("decrypt", "Decrypt a string previsouly encrypted with the same key (or key pair)", (OptionHandler)new DecryptOptionHandler());
    }

    public String getUsageHelp() {
        return "[options] <text>";
    }

    private static class DecryptOptionHandler
    extends BaseEncryptOptionHandler {
        private DecryptOptionHandler() {
        }

        protected synchronized ExitStatus run(OptionSet options) throws Exception {
            TextEncryptor encryptor = this.createEncryptor(options);
            String text = StringUtils.collectionToDelimitedString((Collection)options.nonOptionArguments(), (String)" ");
            if (text.startsWith("{cipher}")) {
                text = text.substring("{cipher}".length());
            }
            System.out.println(encryptor.decrypt(text));
            return ExitStatus.OK;
        }
    }
}

