/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.cli.compiler;

import groovy.grape.Grape;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.eclipse.aether.graph.Dependency;
import org.springframework.boot.cli.compiler.CompilerAutoConfiguration;
import org.springframework.boot.cli.compiler.DependencyCustomizer;
import org.springframework.boot.dependency.tools.Dependencies;
import org.springframework.boot.dependency.tools.ManagedDependencies;
import org.springframework.boot.dependency.tools.PropertiesFileDependencies;

public class SpringCloudCompilerAutoConfiguration
extends CompilerAutoConfiguration {
    public void applyDependencies(DependencyCustomizer dependencies) {
        this.addManagedDependencies(dependencies);
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.boot.actuate.endpoint.EnvironmentEndpoint"}).add(new String[]{"spring-boot-starter-actuator"});
        dependencies.ifAnyMissingClasses(new String[]{"org.springframework.cloud.config.Environment"}).add(new String[]{"spring-cloud-config-client"});
    }

    public void applyImports(ImportCustomizer imports) throws CompilationFailedException {
        imports.addImports(new String[]{"org.springframework.cloud.context.config.annotation.RefreshScope"});
    }

    private void addManagedDependencies(DependencyCustomizer dependencies) {
        ArrayList<Dependencies> managedDependencies = new ArrayList<Dependencies>();
        managedDependencies.add(new AetherManagedDependencies(dependencies.getDependencyResolutionContext().getManagedDependencies()));
        managedDependencies.addAll(this.getAdditionalDependencies());
        dependencies.getDependencyResolutionContext().setManagedDependencies(ManagedDependencies.get(managedDependencies));
    }

    private List<Dependencies> getAdditionalDependencies() {
        String version = this.getVersion();
        String[] components = ("org.springframework.cloud:spring-cloud-versions:" + version).split(":");
        HashMap<String, String> dependency = new HashMap<String, String>();
        dependency.put("group", components[0]);
        dependency.put("module", components[1]);
        dependency.put("version", components[2]);
        dependency.put("type", "properties");
        URI[] uris = Grape.getInstance().resolve(null, new Map[]{dependency});
        ArrayList<Dependencies> managedDependencies = new ArrayList<Dependencies>(uris.length);
        URI[] uRIArray = uris;
        int n = uris.length;
        int n2 = 0;
        while (n2 < n) {
            URI uri = uRIArray[n2];
            try {
                managedDependencies.add((Dependencies)new PropertiesFileDependencies(uri.toURL().openStream()));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to parse '" + uris[0] + "'. Is it a valid properties file?", ex);
            }
            ++n2;
        }
        return managedDependencies;
    }

    private String getVersion() {
        try {
            Package pkg = ((Object)((Object)this)).getClass().getPackage();
            if (pkg != null) {
                return pkg.getImplementationVersion();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "1.0.0.BUILD-SNAPSHOT";
    }

    static class AetherManagedDependencies
    implements Dependencies {
        private Map<String, org.springframework.boot.dependency.tools.Dependency> groupAndArtifactToDependency = new HashMap<String, org.springframework.boot.dependency.tools.Dependency>();
        private Map<String, String> artifactToGroupAndArtifact = new HashMap<String, String>();

        public AetherManagedDependencies(List<Dependency> dependencies) {
            for (Dependency dependency : dependencies) {
                String groupId = dependency.getArtifact().getGroupId();
                String artifactId = dependency.getArtifact().getArtifactId();
                String version = dependency.getArtifact().getVersion();
                ArrayList exclusions = new ArrayList();
                org.springframework.boot.dependency.tools.Dependency value = new org.springframework.boot.dependency.tools.Dependency(groupId, artifactId, version, exclusions);
                this.groupAndArtifactToDependency.put(String.valueOf(groupId) + ":" + artifactId, value);
                this.artifactToGroupAndArtifact.put(artifactId, String.valueOf(groupId) + ":" + artifactId);
            }
        }

        public org.springframework.boot.dependency.tools.Dependency find(String groupId, String artifactId) {
            return this.groupAndArtifactToDependency.get(String.valueOf(groupId) + ":" + artifactId);
        }

        public org.springframework.boot.dependency.tools.Dependency find(String artifactId) {
            String groupAndArtifact = this.artifactToGroupAndArtifact.get(artifactId);
            if (groupAndArtifact == null) {
                return null;
            }
            return this.groupAndArtifactToDependency.get(groupAndArtifact);
        }

        public Iterator<org.springframework.boot.dependency.tools.Dependency> iterator() {
            return this.groupAndArtifactToDependency.values().iterator();
        }
    }
}

