/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.event;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.UUID;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.StringUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonIgnoreProperties(value={"source"})
public abstract class RemoteApplicationEvent
extends ApplicationEvent {
    private static final Object TRANSIENT_SOURCE = new Object();
    private final String originService;
    private final String destinationService;
    private final String id;

    protected RemoteApplicationEvent() {
        this(TRANSIENT_SOURCE, null, null);
    }

    protected RemoteApplicationEvent(Object source, String originService, String destinationService) {
        super(source);
        this.originService = originService;
        if (destinationService == null) {
            destinationService = "**";
        }
        if (!"**".equals(destinationService) && StringUtils.countOccurrencesOf((String)destinationService, (String)":") <= 1 && !StringUtils.endsWithIgnoreCase((String)destinationService, (String)":**")) {
            destinationService = destinationService + ":**";
        }
        this.destinationService = destinationService;
        this.id = UUID.randomUUID().toString();
    }

    protected RemoteApplicationEvent(Object source, String originService) {
        this(source, originService, null);
    }

    public String getOriginService() {
        return this.originService;
    }

    public String getDestinationService() {
        return this.destinationService;
    }

    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destinationService == null ? 0 : this.destinationService.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.originService == null ? 0 : this.originService.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RemoteApplicationEvent other = (RemoteApplicationEvent)((Object)obj);
        if (this.destinationService == null ? other.destinationService != null : !this.destinationService.equals(other.destinationService)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.originService == null ? other.originService != null : !this.originService.equals(other.originService));
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.id).append("originService", (Object)this.originService).append("destinationService", (Object)this.destinationService).toString();
    }
}

