/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.jackson;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.cloud.bus.jackson.SubtypeModule;
import org.springframework.cloud.stream.converter.AbstractFromMessageConverter;
import org.springframework.cloud.stream.converter.MessageConverterUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.messaging.Message;
import org.springframework.util.ClassUtils;
import org.springframework.util.MimeTypeUtils;

class BusJacksonMessageConverter
extends AbstractFromMessageConverter {
    private static final String DEFAULT_PACKAGE = ClassUtils.getPackageName(RemoteApplicationEvent.class);
    private static final String CLASS_RESOURCE_PATTERN = "/**/*.class";
    private final ObjectMapper mapper = new ObjectMapper();
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private String[] packagesToScan = new String[]{DEFAULT_PACKAGE};

    public void setPackagesToScan(String[] packagesToScan) {
        ArrayList<String> packages = new ArrayList<String>(Arrays.asList(packagesToScan));
        if (!packages.contains(DEFAULT_PACKAGE)) {
            packages.add(DEFAULT_PACKAGE);
        }
        this.packagesToScan = packages.toArray(new String[0]);
    }

    public BusJacksonMessageConverter() {
        super(MimeTypeUtils.APPLICATION_JSON, MessageConverterUtils.X_JAVA_OBJECT);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.registerModule((Module)new SubtypeModule(this.findSubTypes()));
    }

    private Class<?>[] findSubTypes() {
        ArrayList<Class> types = new ArrayList<Class>();
        if (this.packagesToScan != null) {
            for (String pkg : this.packagesToScan) {
                try {
                    String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + CLASS_RESOURCE_PATTERN;
                    Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                    CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                    for (Resource resource : resources) {
                        if (!resource.isReadable()) continue;
                        MetadataReader reader = readerFactory.getMetadataReader(resource);
                        String className = reader.getClassMetadata().getClassName();
                        try {
                            Class type = ClassUtils.forName((String)className, null);
                            types.add(type);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Failed to scan classpath for remote event classes", ex);
                }
            }
        }
        return types.toArray(new Class[0]);
    }

    protected Class<?>[] supportedPayloadTypes() {
        return new Class[]{String.class, byte[].class};
    }

    protected Class<?>[] supportedTargetTypes() {
        return new Class[]{RemoteApplicationEvent.class};
    }

    public Object convertFromInternal(Message<?> message, Class<?> targetClass, Object conversionHint) {
        Object result = null;
        try {
            Object payload = message.getPayload();
            if (payload instanceof byte[]) {
                result = this.mapper.readValue((byte[])payload, targetClass);
            } else if (payload instanceof String) {
                result = this.mapper.readValue((String)payload, targetClass);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        return result;
    }
}

