/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.event;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.springframework.context.ApplicationEvent;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonIgnoreProperties(value={"source"})
public abstract class RemoteApplicationEvent
extends ApplicationEvent {
    private static final Object TRANSIENT_SOURCE = new Object();
    private final String originService;
    private final String destinationService;

    protected RemoteApplicationEvent() {
        super(TRANSIENT_SOURCE);
        this.originService = null;
        this.destinationService = null;
    }

    protected RemoteApplicationEvent(Object source, String originService, String destinationService) {
        super(source);
        this.originService = originService;
        this.destinationService = destinationService;
    }

    protected RemoteApplicationEvent(Object source, String originService) {
        this(source, originService, null);
    }

    public String getOriginService() {
        return this.originService;
    }

    public String getDestinationService() {
        return this.destinationService;
    }

    public String toString() {
        return "RemoteApplicationEvent(originService=" + this.getOriginService() + ", destinationService=" + this.getDestinationService() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoteApplicationEvent)) {
            return false;
        }
        RemoteApplicationEvent other = (RemoteApplicationEvent)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$originService = this.getOriginService();
        String other$originService = other.getOriginService();
        if (this$originService == null ? other$originService != null : !this$originService.equals(other$originService)) {
            return false;
        }
        String this$destinationService = this.getDestinationService();
        String other$destinationService = other.getDestinationService();
        return !(this$destinationService == null ? other$destinationService != null : !this$destinationService.equals(other$destinationService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemoteApplicationEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $originService = this.getOriginService();
        result = result * 59 + ($originService == null ? 0 : $originService.hashCode());
        String $destinationService = this.getDestinationService();
        result = result * 59 + ($destinationService == null ? 0 : $destinationService.hashCode());
        return result;
    }
}

