/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.rsocket;

import io.rsocket.routing.client.spring.RoutingRSocketRequester;
import io.rsocket.routing.common.Key;
import io.rsocket.routing.common.WellKnownKey;
import io.rsocket.routing.frames.Address;
import io.rsocket.routing.frames.RoutingType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.cloud.bus.BusBridge;
import org.springframework.cloud.bus.event.RemoteApplicationEvent;
import org.springframework.util.StringUtils;

public class RSocketRequesterBusBridge
implements BusBridge {
    private final RoutingRSocketRequester requester;

    public RSocketRequesterBusBridge(RoutingRSocketRequester requester) {
        this.requester = requester;
    }

    public void send(RemoteApplicationEvent event) {
        this.requester.route("busConsumer", new Object[0]).address(builder -> {
            builder.routingType(RoutingType.MULTICAST);
            RSocketRequesterBusBridge.getTagsFromDestination(event.getDestinationService()).forEach((arg_0, arg_1) -> ((Address.Builder)builder).with(arg_0, arg_1));
        }).data((Object)event).send().subscribe();
    }

    static Map<Key, String> getTagsFromDestination(String delimitedProperties) {
        String[] properties = StringUtils.tokenizeToStringArray((String)delimitedProperties, (String)":");
        HashMap<Key, String> map = new HashMap<Key, String>();
        for (String property : properties) {
            int index = RSocketRequesterBusBridge.lowestIndexOf(property, "=");
            String key = index > 0 ? property.substring(0, index) : property;
            String value = index > 0 ? property.substring(index + 1) : null;
            try {
                WellKnownKey wellKnownKey = WellKnownKey.valueOf((String)key);
                map.put(Key.of((WellKnownKey)wellKnownKey), value);
            }
            catch (IllegalArgumentException e) {
                try {
                    WellKnownKey wellKnownKey = WellKnownKey.valueOf((String)key.toUpperCase(Locale.ROOT));
                    map.put(Key.of((WellKnownKey)wellKnownKey), value);
                }
                catch (IllegalArgumentException e2) {
                    map.put(Key.of((String)key), value);
                }
            }
        }
        return map;
    }

    private static int lowestIndexOf(String property, String ... candidates) {
        int index = -1;
        for (String candidate : candidates) {
            int candidateIndex = property.indexOf(candidate);
            if (candidateIndex <= 0) continue;
            index = index != -1 ? Math.min(index, candidateIndex) : candidateIndex;
        }
        return index;
    }
}

