/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.bus.rsocket;

import io.rsocket.RSocket;
import io.rsocket.routing.client.spring.RoutingClientProperties;
import io.rsocket.routing.client.spring.RoutingRSocketRequester;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.bus.BusAutoConfiguration;
import org.springframework.cloud.bus.BusProperties;
import org.springframework.cloud.bus.BusRefreshAutoConfiguration;
import org.springframework.cloud.bus.ConditionalOnBusEnabled;
import org.springframework.cloud.bus.PathServiceMatcherAutoConfiguration;
import org.springframework.cloud.bus.rsocket.BusRSocketProperties;
import org.springframework.cloud.bus.rsocket.RSocketRequesterBusBridge;
import org.springframework.cloud.bus.rsocket.RSocketServiceMatcher;
import org.springframework.cloud.bus.rsocket.RoutingClientDestinationFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBusEnabled
@EnableConfigurationProperties(value={BusRSocketProperties.class})
@ConditionalOnClass(value={RSocket.class, RoutingRSocketRequester.class})
@AutoConfigureBefore(value={BusAutoConfiguration.class, BusRefreshAutoConfiguration.class, PathServiceMatcherAutoConfiguration.class})
public class BusRSocketAutoConfiguration {
    @Bean
    public RoutingClientDestinationFactory routingClientDestinationFactory(BusRSocketProperties properties) {
        return new RoutingClientDestinationFactory(properties);
    }

    @Bean
    public RSocketRequesterBusBridge rSocketRequesterBusBridge(RoutingRSocketRequester requester) {
        return new RSocketRequesterBusBridge(requester);
    }

    @Bean
    public RSocketServiceMatcher rSocketServiceMatcher(BusProperties properties, RoutingClientProperties routingClientProperties) {
        return new RSocketServiceMatcher(properties.getId(), routingClientProperties);
    }
}

