/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.messaging.core;

import com.amazonaws.services.sns.AmazonSNS;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.cloud.aws.core.env.ResourceIdResolver;
import org.springframework.cloud.aws.messaging.core.TopicMessageChannel;
import org.springframework.cloud.aws.messaging.core.support.AbstractMessageChannelMessagingSendingTemplate;
import org.springframework.cloud.aws.messaging.support.destination.DynamicTopicDestinationResolver;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.ClassUtils;

public class NotificationMessagingTemplate
extends AbstractMessageChannelMessagingSendingTemplate<TopicMessageChannel> {
    private final AmazonSNS amazonSns;
    private static final boolean JACKSON_2_PRESENT = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)NotificationMessagingTemplate.class.getClassLoader());

    public NotificationMessagingTemplate(AmazonSNS amazonSns) {
        this(amazonSns, (ResourceIdResolver)null, null);
    }

    public NotificationMessagingTemplate(AmazonSNS amazonSns, ResourceIdResolver resourceIdResolver) {
        this(amazonSns, resourceIdResolver, null);
    }

    public NotificationMessagingTemplate(AmazonSNS amazonSns, ResourceIdResolver resourceIdResolver, MessageConverter messageConverter) {
        super(new DynamicTopicDestinationResolver(amazonSns, resourceIdResolver));
        this.amazonSns = amazonSns;
        this.initMessageConverter(messageConverter);
    }

    public NotificationMessagingTemplate(AmazonSNS amazonSns, DestinationResolver<String> destinationResolver, MessageConverter messageConverter) {
        super(destinationResolver);
        this.amazonSns = amazonSns;
        this.initMessageConverter(messageConverter);
    }

    private void initMessageConverter(MessageConverter messageConverter) {
        StringMessageConverter stringMessageConverter = new StringMessageConverter();
        stringMessageConverter.setSerializedPayloadClass(String.class);
        ArrayList<Object> messageConverters = new ArrayList<Object>();
        messageConverters.add(stringMessageConverter);
        if (messageConverter != null) {
            messageConverters.add(messageConverter);
        } else if (JACKSON_2_PRESENT) {
            MappingJackson2MessageConverter mappingJackson2MessageConverter = new MappingJackson2MessageConverter();
            mappingJackson2MessageConverter.setSerializedPayloadClass(String.class);
            messageConverters.add(mappingJackson2MessageConverter);
        }
        this.setMessageConverter((MessageConverter)new CompositeMessageConverter(messageConverters));
    }

    @Override
    protected TopicMessageChannel resolveMessageChannel(String physicalResourceIdentifier) {
        return new TopicMessageChannel(this.amazonSns, physicalResourceIdentifier);
    }

    public void sendNotification(String destinationName, Object message, String subject) {
        this.convertAndSend(destinationName, message, Collections.singletonMap("NOTIFICATION_SUBJECT_HEADER", subject));
    }

    public void sendNotification(Object message, String subject) {
        this.convertAndSend(this.getRequiredDefaultDestination(), message, Collections.singletonMap("NOTIFICATION_SUBJECT_HEADER", subject));
    }
}

