/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.context.config.annotation;

import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.aws.context.config.annotation.EnableContextRegion;
import org.springframework.cloud.aws.context.config.support.ContextConfigurationUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

@Configuration
public class ContextRegionConfigurationRegistrar
implements ImportBeanDefinitionRegistrar {
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)importingClassMetadata.getAnnotationAttributes(EnableContextRegion.class.getName(), false));
        Assert.notNull((Object)annotationAttributes, (String)("@EnableRegionProvider is not present on importing class " + importingClassMetadata.getClassName()));
        boolean autoDetect = annotationAttributes.getBoolean("autoDetect");
        String configuredRegion = annotationAttributes.getString("region");
        ContextConfigurationUtils.registerRegionProvider(registry, autoDetect, configuredRegion);
    }
}

