/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.context;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.aws.autoconfigure.context.properties.AwsCredentialsProperties;
import org.springframework.cloud.aws.context.config.annotation.ContextDefaultConfigurationRegistrar;
import org.springframework.cloud.aws.context.config.support.ContextConfigurationUtils;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

@Configuration
@Import(value={ContextDefaultConfigurationRegistrar.class, Registrar.class})
@ConditionalOnClass(name={"com.amazonaws.auth.AWSCredentialsProvider"})
public class ContextCredentialsAutoConfiguration {
    public static final String AWS_CREDENTIALS_PROPERTY_PREFIX = "cloud.aws.credentials";

    @Bean
    @ConfigurationProperties(prefix="cloud.aws.credentials")
    public AwsCredentialsProperties awsCredentialsProperties() {
        return new AwsCredentialsProperties();
    }

    public static class Registrar
    implements ImportBeanDefinitionRegistrar,
    EnvironmentAware {
        private Environment environment;

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            if (registry.containsBeanDefinition("credentialsProvider")) {
                return;
            }
            Boolean useDefaultCredentialsChain = (Boolean)this.environment.getProperty("cloud.aws.credentials.useDefaultAwsCredentialsChain", Boolean.class, (Object)false);
            String accessKey = this.environment.getProperty("cloud.aws.credentials.accessKey");
            String secretKey = this.environment.getProperty("cloud.aws.credentials.secretKey");
            if (useDefaultCredentialsChain.booleanValue() && (StringUtils.isEmpty((Object)accessKey) || StringUtils.isEmpty((Object)secretKey))) {
                ContextConfigurationUtils.registerDefaultAWSCredentialsProvider((BeanDefinitionRegistry)registry);
            } else {
                ContextConfigurationUtils.registerCredentialsProvider((BeanDefinitionRegistry)registry, (String)accessKey, (String)secretKey, ((Boolean)this.environment.getProperty("cloud.aws.credentials.instanceProfile", Boolean.class, (Object)true) != false && !this.environment.containsProperty("cloud.aws.credentials.accessKey") ? 1 : 0) != 0, (String)this.environment.getProperty("cloud.aws.credentials.profileName", "default"), (String)this.environment.getProperty("cloud.aws.credentials.profilePath"));
            }
        }
    }
}

