/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.context;

import com.amazonaws.services.s3.AmazonS3Client;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.aws.context.config.annotation.ContextResourceLoaderConfiguration;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@Import(value={Registrar.class})
@ConditionalOnClass(value={AmazonS3Client.class})
public class ContextResourceLoaderAutoConfiguration {

    public static class Registrar
    extends ContextResourceLoaderConfiguration.Registrar
    implements EnvironmentAware {
        private static final String PROPERTY_PREFIX = "cloud.aws.loader";
        private static final String CORE_POOL_SIZE_PROPERTY_NAME = "corePoolSize";
        private static final String MAX_POOL_SIZE_PROPERTY_NAME = "maxPoolSize";
        private static final String QUEUE_CAPACITY_PROPERTY_NAME = "queueCapacity";
        private Environment environment;

        public void setEnvironment(Environment environment) {
            this.environment = environment;
        }

        protected BeanDefinition getTaskExecutorDefinition() {
            if (this.containsProperty(CORE_POOL_SIZE_PROPERTY_NAME) || this.containsProperty(MAX_POOL_SIZE_PROPERTY_NAME) || this.containsProperty(QUEUE_CAPACITY_PROPERTY_NAME)) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ThreadPoolTaskExecutor.class);
                this.setPropertyIfConfigured(builder, CORE_POOL_SIZE_PROPERTY_NAME);
                this.setPropertyIfConfigured(builder, MAX_POOL_SIZE_PROPERTY_NAME);
                this.setPropertyIfConfigured(builder, QUEUE_CAPACITY_PROPERTY_NAME);
                return builder.getBeanDefinition();
            }
            return super.getTaskExecutorDefinition();
        }

        private boolean containsProperty(String name) {
            return this.environment.containsProperty("cloud.aws.loader." + name);
        }

        private String getProperty(String name) {
            return this.environment.getProperty("cloud.aws.loader." + name);
        }

        private void setPropertyIfConfigured(BeanDefinitionBuilder builder, String name) {
            if (this.containsProperty(name)) {
                builder.addPropertyValue(name, (Object)this.getProperty(name));
            }
        }
    }
}

