/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.aws.autoconfigure.context;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.aws.autoconfigure.context.ContextCredentialsAutoConfiguration;
import org.springframework.cloud.aws.context.annotation.ConditionalOnAwsCloudEnvironment;
import org.springframework.cloud.aws.context.config.annotation.ContextDefaultConfigurationRegistrar;
import org.springframework.cloud.aws.context.config.annotation.ContextStackConfiguration;
import org.springframework.cloud.aws.core.env.stack.config.StackResourceRegistryFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={ContextCredentialsAutoConfiguration.class, ContextDefaultConfigurationRegistrar.class})
public class ContextStackAutoConfiguration {

    @Configuration
    @ConditionalOnProperty(prefix="cloud.aws", name={"stack.auto"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnAwsCloudEnvironment
    @ConditionalOnMissingBean(value={StackResourceRegistryFactoryBean.class})
    public static class StackAutoDetectConfiguration
    extends ContextStackConfiguration {
        @Bean
        public StackResourceRegistryFactoryBean stackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormation) {
            return new StackResourceRegistryFactoryBean(amazonCloudFormation);
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"cloud.aws.stack.name"})
    public static class StackManualDetectConfiguration
    extends ContextStackConfiguration {
        @Autowired
        private Environment environment;

        @Bean
        public StackResourceRegistryFactoryBean stackResourceRegistryFactoryBean(AmazonCloudFormation amazonCloudFormation) {
            return new StackResourceRegistryFactoryBean(amazonCloudFormation, this.environment.getProperty("cloud.aws.stack.name"));
        }
    }
}

