/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.logging.recent.endpoint;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import org.springframework.cloud.appbroker.logging.recent.endpoint.EncodingException;

class MultipartEncoder
implements Closeable {
    private final byte[] bytesCRLF = new byte[]{13, 10};
    private final byte[] bytesSEP = new byte[]{45, 45};
    private final byte[] boundary;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    MultipartEncoder(String boundary) {
        this.boundary = boundary.getBytes();
    }

    void append(byte[] part) {
        try {
            this.out.write(this.bytesCRLF);
            this.out.write(this.bytesSEP);
            this.out.write(this.boundary);
            this.out.write(this.bytesCRLF);
            this.out.write(this.bytesCRLF);
            this.out.write(part);
        }
        catch (IOException ex) {
            throw new EncodingException(ex);
        }
    }

    byte[] terminateAndGetBytes() {
        try {
            this.out.write(this.bytesCRLF);
            this.out.write(this.bytesSEP);
            this.out.write(this.boundary);
            this.out.write(this.bytesSEP);
            this.out.write(this.bytesCRLF);
            byte[] bytes = this.out.toByteArray();
            this.out.close();
            return bytes;
        }
        catch (IOException ex) {
            throw new EncodingException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

