/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.logging;

import java.util.Base64;
import okio.ByteString;
import org.cloudfoundry.dropsonde.events.Envelope;
import org.cloudfoundry.dropsonde.events.LogMessage;

public final class LoggingUtils {
    private LoggingUtils() {
    }

    public static Envelope convertLogCacheEnvelopeToDropsonde(org.cloudfoundry.logcache.v1.Envelope envelope) {
        Envelope.Builder builder = new Envelope.Builder().eventType(Envelope.EventType.LogMessage).tags(envelope.getTags()).origin(LoggingUtils.getFromTags(envelope, "rep")).timestamp(envelope.getTimestamp()).logMessage(new LogMessage.Builder().message(ByteString.of((byte[])Base64.getDecoder().decode(envelope.getLog().getPayload()))).message_type(LoggingUtils.getMessageType(envelope)).timestamp(envelope.getTimestamp()).source_instance(envelope.getInstanceId()).source_type(LoggingUtils.getFromTags(envelope, "source_type")).build());
        return builder.build();
    }

    private static String getFromTags(org.cloudfoundry.logcache.v1.Envelope envelope, String sourceTypeTag) {
        String sourceType = (String)envelope.getTags().get(sourceTypeTag);
        if (sourceType == null) {
            sourceType = "";
        }
        return sourceType;
    }

    private static LogMessage.MessageType getMessageType(org.cloudfoundry.logcache.v1.Envelope envelope) {
        LogMessage.MessageType messageType = "ERR".equals(envelope.getLog().getType().getValue()) ? LogMessage.MessageType.ERR : LogMessage.MessageType.OUT;
        return messageType;
    }
}

