/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.logging.streaming;

import java.util.HashMap;
import java.util.Map;
import org.cloudfoundry.dropsonde.events.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.appbroker.logging.LoggingUtils;
import org.springframework.cloud.appbroker.logging.streaming.LogStreamPublisher;
import org.springframework.cloud.appbroker.logging.streaming.events.ServiceInstanceLogEvent;
import org.springframework.cloud.appbroker.logging.streaming.events.ServiceInstanceLoggingEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;

public class ApplicationLogStreamPublisher
implements ApplicationListener<ServiceInstanceLoggingEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationLogStreamPublisher.class);
    private final Map<String, Registration> registry = new HashMap<String, Registration>();
    private final LogStreamPublisher<org.cloudfoundry.doppler.Envelope> logStreamPublisher;
    private final ApplicationEventPublisher publisher;

    public ApplicationLogStreamPublisher(LogStreamPublisher<org.cloudfoundry.doppler.Envelope> logStreamPublisher, ApplicationEventPublisher publisher) {
        this.logStreamPublisher = logStreamPublisher;
        this.publisher = publisher;
    }

    public void onApplicationEvent(ServiceInstanceLoggingEvent event) {
        String serviceInstanceId = event.getServiceInstanceId();
        switch (event.getOperation()) {
            case START: {
                LOG.debug("Received event to begin listening to logs for {}", (Object)serviceInstanceId);
                this.startPublishing(serviceInstanceId);
                return;
            }
            case STOP: {
                LOG.debug("Received event to stop listening to logs for {}", (Object)serviceInstanceId);
                this.stopPublishing(serviceInstanceId);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown operation: " + (Object)((Object)event.getOperation()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPublishing(String serviceInstanceId) {
        Map<String, Registration> map = this.registry;
        synchronized (map) {
            Registration registration = this.registry.get(serviceInstanceId);
            if (registration != null) {
                LOG.debug("Incrementing registration subscription count for {}", (Object)serviceInstanceId);
                registration.increment();
                return;
            }
            Flux<org.cloudfoundry.doppler.Envelope> logStream = this.logStreamPublisher.getLogStream(serviceInstanceId);
            Disposable subscription = logStream.map(LoggingUtils::convertDopplerEnvelopeToDropsonde).doOnNext(envelope -> this.publisher.publishEvent((ApplicationEvent)new ServiceInstanceLogEvent(this, serviceInstanceId, (Envelope)envelope))).subscribe();
            LOG.debug("Creating new registration for {}", (Object)serviceInstanceId);
            this.registry.put(serviceInstanceId, new Registration(subscription));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopPublishing(String serviceInstanceId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Received event to stop listening to logs for {}", (Object)serviceInstanceId);
        }
        Map<String, Registration> map = this.registry;
        synchronized (map) {
            Registration registration = this.registry.get(serviceInstanceId);
            if (registration == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Received deregister event for service instance {} but there no event handler registered", (Object)serviceInstanceId);
                }
            } else if (registration.decrement() == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Disposing of registration since there are no more subscriptions");
                }
                registration.getSubscription().dispose();
                this.registry.remove(serviceInstanceId);
            }
        }
    }

    private static final class Registration {
        private final Disposable subscription;
        private int count = 1;

        private Registration(Disposable subscription) {
            this.subscription = subscription;
        }

        public void increment() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Incrementing subscription count from {} to {}", (Object)this.count, (Object)(this.count + 1));
            }
            ++this.count;
        }

        public int decrement() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Decrementing subscription count from {} to {}", (Object)this.count, (Object)(this.count - 1));
            }
            return --this.count;
        }

        public Disposable getSubscription() {
            return this.subscription;
        }
    }
}

