/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.logging.streaming;

import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.applications.GetApplicationRequest;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.doppler.Envelope;
import org.cloudfoundry.doppler.StreamRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.appbroker.logging.ApplicationIdsProvider;
import org.springframework.cloud.appbroker.logging.LoggingUtils;
import org.springframework.cloud.appbroker.logging.streaming.LogStreamPublisher;
import reactor.core.publisher.Flux;

public class DopplerLogStreamPublisher
implements LogStreamPublisher<Envelope> {
    private static final Logger LOG = LoggerFactory.getLogger(DopplerLogStreamPublisher.class);
    private final CloudFoundryClient client;
    private final DopplerClient dopplerClient;
    private final ApplicationIdsProvider applicationIdsProvider;

    public DopplerLogStreamPublisher(CloudFoundryClient client, DopplerClient dopplerClient, ApplicationIdsProvider applicationIdsProvider) {
        this.client = client;
        this.dopplerClient = dopplerClient;
        this.applicationIdsProvider = applicationIdsProvider;
    }

    @Override
    public Flux<Envelope> getLogStream(String serviceInstanceId) {
        return this.applicationIdsProvider.getApplicationIds(serviceInstanceId).doOnNext(id -> LOG.debug("Starting log streaming for app with ID {}", id)).flatMap(this::createApplicationStreamer);
    }

    protected Flux<Envelope> createApplicationStreamer(String applicationId) {
        return this.client.applicationsV2().get(GetApplicationRequest.builder().applicationId(applicationId).build()).map(response -> response.getEntity().getName()).flatMapMany(appName -> this.dopplerClient.stream(StreamRequest.builder().applicationId(applicationId).build()).map(envelope -> LoggingUtils.injectAppNameIntoLogSourceInstance(appName, envelope)));
    }
}

