/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DeployApplicationRequest {
    private final String name;
    private final String path;
    private final Map<String, String> properties;
    private final Map<String, Object> environment;
    private final List<String> services;
    private final String serviceInstanceId;

    protected DeployApplicationRequest(String name, String path, Map<String, String> properties, Map<String, Object> environment, List<String> services, String serviceInstanceId) {
        this.name = name;
        this.path = path;
        this.properties = properties;
        this.environment = environment;
        this.services = services;
        this.serviceInstanceId = serviceInstanceId;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public List<String> getServices() {
        return this.services;
    }

    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public static DeployApplicationRequestBuilder builder() {
        return new DeployApplicationRequestBuilder();
    }

    public static final class DeployApplicationRequestBuilder {
        private String name;
        private String path;
        private final Map<String, String> properties = new HashMap<String, String>();
        private final Map<String, Object> environment = new HashMap<String, Object>();
        private final List<String> services = new ArrayList<String>();
        private String serviceInstanceId;

        private DeployApplicationRequestBuilder() {
        }

        public DeployApplicationRequestBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DeployApplicationRequestBuilder path(String path) {
            this.path = path;
            return this;
        }

        public DeployApplicationRequestBuilder property(String key, String value) {
            if (key != null && value != null) {
                this.properties.put(key, value);
            }
            return this;
        }

        public DeployApplicationRequestBuilder properties(Map<String, String> properties) {
            if (!CollectionUtils.isEmpty(properties)) {
                this.properties.putAll(properties);
            }
            return this;
        }

        public DeployApplicationRequestBuilder environment(String key, String value) {
            if (key != null && value != null) {
                this.environment.put(key, value);
            }
            return this;
        }

        public DeployApplicationRequestBuilder environment(Map<String, Object> environment) {
            if (!CollectionUtils.isEmpty(environment)) {
                this.environment.putAll(environment);
            }
            return this;
        }

        public DeployApplicationRequestBuilder service(String service) {
            if (service != null) {
                this.services.add(service);
            }
            return this;
        }

        public DeployApplicationRequestBuilder services(List<String> services) {
            if (!CollectionUtils.isEmpty(services)) {
                this.services.addAll(services);
            }
            return this;
        }

        public DeployApplicationRequestBuilder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
            return this;
        }

        public DeployApplicationRequest build() {
            return new DeployApplicationRequest(this.name, this.path, this.properties, this.environment, this.services, this.serviceInstanceId);
        }
    }
}

