/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.cloudfoundry;

import java.util.List;
import java.util.stream.Collectors;
import org.cloudfoundry.uaa.UaaClient;
import org.cloudfoundry.uaa.clients.CreateClientRequest;
import org.cloudfoundry.uaa.clients.CreateClientResponse;
import org.cloudfoundry.uaa.clients.DeleteClientRequest;
import org.cloudfoundry.uaa.clients.DeleteClientResponse;
import org.cloudfoundry.uaa.tokens.GrantType;
import org.springframework.cloud.appbroker.deployer.oauth2.CreateOAuth2ClientRequest;
import org.springframework.cloud.appbroker.deployer.oauth2.CreateOAuth2ClientResponse;
import org.springframework.cloud.appbroker.deployer.oauth2.DeleteOAuth2ClientRequest;
import org.springframework.cloud.appbroker.deployer.oauth2.DeleteOAuth2ClientResponse;
import org.springframework.cloud.appbroker.deployer.oauth2.OAuth2Client;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Mono;

public class CloudFoundryOAuth2Client
implements OAuth2Client {
    private final UaaClient uaaClient;

    public CloudFoundryOAuth2Client(UaaClient uaaClient) {
        this.uaaClient = uaaClient;
    }

    public Mono<CreateOAuth2ClientResponse> createClient(CreateOAuth2ClientRequest request) {
        return this.uaaClient.clients().create(this.mapCreateRequest(request)).map(this::mapCreateResponse);
    }

    public Mono<DeleteOAuth2ClientResponse> deleteClient(DeleteOAuth2ClientRequest request) {
        return this.uaaClient.clients().delete(this.mapDeleteRequest(request)).map(this::mapDeleteResponse);
    }

    private CreateClientRequest mapCreateRequest(CreateOAuth2ClientRequest request) {
        return CreateClientRequest.builder().clientId(request.getClientId()).clientSecret(request.getClientSecret()).name(request.getClientName()).scopes((Iterable)request.getScopes()).authorities((Iterable)request.getAuthorities()).authorizedGrantTypes(this.mapStringToGrantType(request.getGrantTypes())).identityZoneSubdomain(request.getIdentityZoneSubdomain()).identityZoneId(request.getIdentityZoneId()).build();
    }

    private CreateOAuth2ClientResponse mapCreateResponse(CreateClientResponse response) {
        return CreateOAuth2ClientResponse.builder().clientId(response.getClientId()).clientName(response.getName()).scopes(response.getScopes()).authorities(response.getAuthorities()).grantTypes(this.mapGrantTypeToString(response.getAuthorizedGrantTypes())).build();
    }

    private DeleteClientRequest mapDeleteRequest(DeleteOAuth2ClientRequest request) {
        return DeleteClientRequest.builder().clientId(request.getClientId()).identityZoneSubdomain(request.getIdentityZoneSubdomain()).identityZoneId(request.getIdentityZoneId()).build();
    }

    private DeleteOAuth2ClientResponse mapDeleteResponse(DeleteClientResponse response) {
        return DeleteOAuth2ClientResponse.builder().clientId(response.getClientId()).clientName(response.getName()).scopes(response.getScopes()).authorities(response.getAuthorities()).grantTypes(this.mapGrantTypeToString(response.getAuthorizedGrantTypes())).build();
    }

    private List<GrantType> mapStringToGrantType(List<String> grantTypes) {
        if (CollectionUtils.isEmpty(grantTypes)) {
            return null;
        }
        return grantTypes.stream().map(GrantType::from).collect(Collectors.toList());
    }

    private List<String> mapGrantTypeToString(List<GrantType> grantTypes) {
        if (CollectionUtils.isEmpty(grantTypes)) {
            return null;
        }
        return grantTypes.stream().map(GrantType::getValue).collect(Collectors.toList());
    }
}

