/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.deployer.cloudfoundry;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudfoundry.AbstractCloudFoundryException;
import org.cloudfoundry.UnknownCloudFoundryException;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.client.v2.applications.AssociateApplicationRouteRequest;
import org.cloudfoundry.client.v2.applications.SummaryApplicationRequest;
import org.cloudfoundry.client.v2.organizations.GetOrganizationRequest;
import org.cloudfoundry.client.v2.organizations.GetOrganizationResponse;
import org.cloudfoundry.client.v2.organizations.ListOrganizationSpacesRequest;
import org.cloudfoundry.client.v2.organizations.OrganizationEntity;
import org.cloudfoundry.client.v2.routes.CreateRouteRequest;
import org.cloudfoundry.client.v2.serviceinstances.ServiceInstanceEntity;
import org.cloudfoundry.client.v2.spaces.AssociateSpaceDeveloperRequest;
import org.cloudfoundry.client.v2.spaces.CreateSpaceRequest;
import org.cloudfoundry.client.v2.spaces.DeleteSpaceRequest;
import org.cloudfoundry.client.v2.spaces.GetSpaceRequest;
import org.cloudfoundry.client.v2.spaces.SpaceEntity;
import org.cloudfoundry.client.v3.BuildpackData;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.LifecycleData;
import org.cloudfoundry.client.v3.LifecycleType;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.cloudfoundry.client.v3.applications.ListApplicationPackagesRequest;
import org.cloudfoundry.client.v3.applications.ListApplicationPackagesResponse;
import org.cloudfoundry.client.v3.applications.UpdateApplicationRequest;
import org.cloudfoundry.client.v3.builds.BuildState;
import org.cloudfoundry.client.v3.builds.CreateBuildRequest;
import org.cloudfoundry.client.v3.builds.CreateBuildResponse;
import org.cloudfoundry.client.v3.builds.GetBuildRequest;
import org.cloudfoundry.client.v3.builds.GetBuildResponse;
import org.cloudfoundry.client.v3.deployments.CreateDeploymentRequest;
import org.cloudfoundry.client.v3.deployments.CreateDeploymentResponse;
import org.cloudfoundry.client.v3.deployments.DeploymentRelationships;
import org.cloudfoundry.client.v3.deployments.DeploymentState;
import org.cloudfoundry.client.v3.deployments.DeploymentStatusReason;
import org.cloudfoundry.client.v3.deployments.DeploymentStatusValue;
import org.cloudfoundry.client.v3.deployments.GetDeploymentRequest;
import org.cloudfoundry.client.v3.deployments.GetDeploymentResponse;
import org.cloudfoundry.client.v3.packages.CreatePackageRequest;
import org.cloudfoundry.client.v3.packages.CreatePackageResponse;
import org.cloudfoundry.client.v3.packages.GetPackageRequest;
import org.cloudfoundry.client.v3.packages.GetPackageResponse;
import org.cloudfoundry.client.v3.packages.PackageRelationships;
import org.cloudfoundry.client.v3.packages.PackageResource;
import org.cloudfoundry.client.v3.packages.PackageState;
import org.cloudfoundry.client.v3.packages.PackageType;
import org.cloudfoundry.client.v3.packages.UploadPackageRequest;
import org.cloudfoundry.client.v3.packages.UploadPackageResponse;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.applications.ApplicationDetail;
import org.cloudfoundry.operations.applications.ApplicationHealthCheck;
import org.cloudfoundry.operations.applications.ApplicationManifest;
import org.cloudfoundry.operations.applications.DeleteApplicationRequest;
import org.cloudfoundry.operations.applications.Docker;
import org.cloudfoundry.operations.applications.PushApplicationManifestRequest;
import org.cloudfoundry.operations.applications.Route;
import org.cloudfoundry.operations.domains.Domain;
import org.cloudfoundry.operations.organizations.OrganizationDetail;
import org.cloudfoundry.operations.organizations.OrganizationInfoRequest;
import org.cloudfoundry.operations.services.BindServiceInstanceRequest;
import org.cloudfoundry.operations.services.GetServiceInstanceRequest;
import org.cloudfoundry.operations.services.ServiceInstance;
import org.cloudfoundry.operations.services.UnbindServiceInstanceRequest;
import org.cloudfoundry.operations.spaces.SpaceDetail;
import org.cloudfoundry.operations.useradmin.SetSpaceRoleRequest;
import org.cloudfoundry.operations.useradmin.SpaceRole;
import org.cloudfoundry.util.DelayUtils;
import org.cloudfoundry.util.PaginationUtils;
import org.cloudfoundry.util.ResourceUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryOperationsUtils;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryTargetProperties;
import org.springframework.cloud.appbroker.deployer.deployer.AppDeployer;
import org.springframework.cloud.appbroker.deployer.deployer.CreateServiceInstanceRequest;
import org.springframework.cloud.appbroker.deployer.deployer.CreateServiceInstanceResponse;
import org.springframework.cloud.appbroker.deployer.deployer.DeleteBackingSpaceRequest;
import org.springframework.cloud.appbroker.deployer.deployer.DeleteBackingSpaceResponse;
import org.springframework.cloud.appbroker.deployer.deployer.DeleteServiceInstanceRequest;
import org.springframework.cloud.appbroker.deployer.deployer.DeleteServiceInstanceResponse;
import org.springframework.cloud.appbroker.deployer.deployer.DeployApplicationRequest;
import org.springframework.cloud.appbroker.deployer.deployer.DeployApplicationResponse;
import org.springframework.cloud.appbroker.deployer.deployer.GetApplicationRequest;
import org.springframework.cloud.appbroker.deployer.deployer.GetApplicationResponse;
import org.springframework.cloud.appbroker.deployer.deployer.GetServiceInstanceResponse;
import org.springframework.cloud.appbroker.deployer.deployer.UndeployApplicationRequest;
import org.springframework.cloud.appbroker.deployer.deployer.UndeployApplicationResponse;
import org.springframework.cloud.appbroker.deployer.deployer.UpdateApplicationResponse;
import org.springframework.cloud.appbroker.deployer.deployer.UpdateServiceInstanceRequest;
import org.springframework.cloud.appbroker.deployer.deployer.UpdateServiceInstanceResponse;
import org.springframework.cloud.appbroker.deployer.deployer.util.ByteSizeUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;

public class CloudFoundryAppDeployer
implements AppDeployer,
ResourceLoaderAware {
    private static final Duration DEFAULT_PLATFORM_OPERATION_DURATION = Duration.ofMinutes(10L);
    private static final Logger LOG = LoggerFactory.getLogger(CloudFoundryAppDeployer.class);
    private static final String REQUEST_LOG_TEMPLATE = "request={}";
    private static final String RESPONSE_LOG_TEMPLATE = "response={}";
    private static final String ERROR_LOG_TEMPLATE = "error=%s";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final CloudFoundryDeploymentProperties defaultDeploymentProperties;
    private final CloudFoundryOperations operations;
    private final CloudFoundryClient client;
    private final CloudFoundryOperationsUtils operationsUtils;
    private final CloudFoundryTargetProperties targetProperties;
    private ResourceLoader resourceLoader;

    public CloudFoundryAppDeployer(CloudFoundryDeploymentProperties deploymentProperties, CloudFoundryOperations operations, CloudFoundryClient client, CloudFoundryOperationsUtils operationsUtils, CloudFoundryTargetProperties targetProperties, ResourceLoader resourceLoader) {
        this.defaultDeploymentProperties = deploymentProperties;
        this.operations = operations;
        this.client = client;
        this.operationsUtils = operationsUtils;
        this.targetProperties = targetProperties;
        this.resourceLoader = resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Mono<GetApplicationResponse> get(GetApplicationRequest request) {
        String appName = request.getName();
        return this.operationsUtils.getOperations(request.getProperties()).flatMap(cfOperations -> cfOperations.applications().get(org.cloudfoundry.operations.applications.GetApplicationRequest.builder().name(appName).build()).doOnRequest(l -> {
            LOG.info("Getting application. appName={}", (Object)appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnSuccess(response -> {
            LOG.info("Success getting application. appName={}", (Object)appName);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error getting application. appName=%s, error=%s", appName, e.getMessage()), e)).map(ApplicationDetail::getId).flatMap(id -> this.client.applicationsV2().summary(SummaryApplicationRequest.builder().applicationId(id).build()))).flatMap(summary -> Flux.fromIterable((Iterable)summary.getServices()).map(org.cloudfoundry.client.v2.serviceinstances.ServiceInstance::getName).collectList().map(services -> GetApplicationResponse.builder().id(summary.getId()).name(summary.getName()).services(services).environment(summary.getEnvironmentJsons()).build())).doOnRequest(l -> {
            LOG.info("Getting application summary. appName={}", (Object)appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnSuccess(response -> {
            LOG.info("Success getting application summary. appName={}", (Object)appName);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error getting application summary. appName=%s, error=%s", appName, e.getMessage()), e));
    }

    public Mono<DeployApplicationResponse> deploy(DeployApplicationRequest request) {
        String appName = request.getName();
        Resource appResource = this.getAppResource(request.getPath());
        Map deploymentProperties = request.getProperties();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Deploying application: request={}, resource={}", (Object)appName, (Object)appResource);
        }
        return this.pushApplication(request, deploymentProperties, appResource).timeout(Duration.ofSeconds(this.defaultDeploymentProperties.getApiTimeout())).doOnSuccess(item -> LOG.info("Successfully deployed {}", (Object)appName)).doOnError(e -> {
            if (this.httpStatusNotFoundPredicate().test((Throwable)e)) {
                LOG.error(String.format("Unable to deploy application. It may have been destroyed before start completed. error=%s", e.getMessage()), e);
            } else {
                this.logError(String.format("Error deploying application. appName=%s", appName)).accept((Throwable)e);
            }
        }).thenReturn((Object)DeployApplicationResponse.builder().name(appName).build());
    }

    public Mono<UpdateApplicationResponse> preUpdate(org.springframework.cloud.appbroker.deployer.deployer.UpdateApplicationRequest request) {
        String appName = request.getName();
        return this.get(GetApplicationRequest.builder().name(appName).properties(request.getProperties()).build()).map(GetApplicationResponse::getId).flatMap(applicationId -> this.updateApplication(request, (String)applicationId)).thenReturn((Object)UpdateApplicationResponse.builder().name(appName).build());
    }

    public Mono<UpdateApplicationResponse> update(org.springframework.cloud.appbroker.deployer.deployer.UpdateApplicationRequest request) {
        String appName = request.getName();
        return this.get(GetApplicationRequest.builder().name(appName).properties(request.getProperties()).build()).flatMap(response -> this.bindNewServices((GetApplicationResponse)response, request.getServices(), request.getProperties())).flatMap(applicationId -> {
            if (request.getProperties().containsKey("routes")) {
                return this.associateRoutes((String)applicationId, request.getProperties());
            }
            return this.associateHostName((String)applicationId, request.getProperties());
        }).flatMap(applicationId -> this.updateApplication(request, (String)applicationId)).flatMap(applicationId -> Mono.zip((Mono)Mono.just((Object)applicationId), this.upgradeApplicationIfRequired(request, (String)applicationId))).flatMap(tuple2 -> {
            String appId = (String)tuple2.getT1();
            String packageId = (String)tuple2.getT2();
            return Mono.zip((Mono)Mono.just((Object)appId), this.createBuildForPackage(packageId));
        }).flatMap(tuple2 -> {
            String appId = (String)tuple2.getT1();
            String buildId = (String)tuple2.getT2();
            return Mono.zip((Mono)Mono.just((Object)appId), this.waitForBuildStaged(buildId));
        }).map(tuple2 -> tuple2.mapT2(t2 -> t2.getDroplet().getId())).flatMap(tuple2 -> {
            String appId = (String)tuple2.getT1();
            String dropletId = (String)tuple2.getT2();
            return this.createDeployment(dropletId, appId);
        }).map(CreateDeploymentResponse::getId).flatMap(this::waitForDeploymentDeployed).doOnRequest(l -> {
            LOG.info("Updating application. appName={}", (Object)appName);
            LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
        }).doOnSuccess(response -> {
            LOG.info("Success updating application. appName={}", (Object)appName);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error updating application. appName=%s", appName), e)).thenReturn((Object)UpdateApplicationResponse.builder().name(appName).build());
    }

    private Mono<String> bindNewServices(GetApplicationResponse deployedApp, List<String> services, Map<String, String> properties) {
        String id = deployedApp.getId();
        List boundServices = deployedApp.getServices();
        ArrayList<String> servicesToBind = new ArrayList<String>(services);
        servicesToBind.removeAll(boundServices);
        if (servicesToBind.isEmpty()) {
            return Mono.just((Object)id);
        }
        String appName = deployedApp.getName();
        return this.operationsUtils.getOperations(properties).flatMapMany(cfOperations -> Flux.fromIterable((Iterable)servicesToBind).flatMap(service -> cfOperations.services().bind(BindServiceInstanceRequest.builder().applicationName(appName).serviceInstanceName(service).build()).doOnRequest(l -> LOG.info("Binding application to service. appName={}, serviceName={}", (Object)appName, service)).doOnNext(v -> LOG.info("Success binding application to service. appName={}, service={}", (Object)appName, service)).doOnError(e -> LOG.error(String.format("Error binding application to service. appName=%s, service=%s", appName, service), e)))).then().thenReturn((Object)id);
    }

    private Mono<String> associateHostName(String applicationId, Map<String, String> properties) {
        String domain = this.domain(properties);
        Set<String> domains = this.domains(properties);
        String host = this.host(properties);
        if (host == null && domain == null && domains.isEmpty()) {
            return Mono.just((Object)applicationId);
        }
        return this.operationsUtils.getOperations(properties).map(cfOperations -> cfOperations.domains().list()).flatMap(Flux::collectList).map(allDomains -> Stream.concat(Stream.of(domain), domains.stream()).map(d -> this.getDomainId((String)d, (List<Domain>)allDomains)).collect(Collectors.toSet())).zipWith(this.getSpaceId(properties)).flatMapMany(domainIdsWithSpaceId -> {
            Set uniqueDomainIds = (Set)domainIdsWithSpaceId.getT1();
            String spaceId = (String)domainIdsWithSpaceId.getT2();
            return Flux.fromIterable((Iterable)uniqueDomainIds).flatMap(domainId -> this.associateHostForDomain(applicationId, host, (String)domainId, spaceId));
        }).then(Mono.just((Object)applicationId));
    }

    private Mono<String> associateRoutes(String applicationId, Map<String, String> properties) {
        List routes = Arrays.stream(properties.get("routes").split(",")).map(uri -> uri.split("\\.", 2)).collect(Collectors.toList());
        return Mono.just(routes).zipWith(this.operationsUtils.getOperations(properties).map(cfOperations -> cfOperations.domains().list()).flatMap(domains -> domains.collectMap(Domain::getName))).zipWith(this.getSpaceId(properties)).flatMapMany(routesDomainsAndSpace -> {
            List routesComponents = (List)((Tuple2)routesDomainsAndSpace.getT1()).getT1();
            Map domainsByName = (Map)((Tuple2)routesDomainsAndSpace.getT1()).getT2();
            String spaceId = (String)routesDomainsAndSpace.getT2();
            return Flux.fromStream(routesComponents.stream().map(route -> new String[]{route[0], ((Domain)domainsByName.get(route[1])).getId()})).flatMap(hostAndDomainId -> this.associateHostForDomain(applicationId, hostAndDomainId[0], hostAndDomainId[1], spaceId));
        }).then(Mono.just((Object)applicationId));
    }

    private Mono<Void> associateHostForDomain(String applicationId, String host, String domainId, String spaceId) {
        return this.client.routes().create(CreateRouteRequest.builder().domainId(domainId).spaceId(spaceId).host(host).build()).map(response -> response.getMetadata().getId()).doOnError(error -> LOG.info("Host was already associated. host={}", (Object)host)).onErrorResume(e -> Mono.empty()).flatMap(routeId -> this.client.applicationsV2().associateRoute(AssociateApplicationRouteRequest.builder().applicationId(applicationId).routeId(routeId).build())).then();
    }

    private Mono<String> getSpaceId(Map<String, String> properties) {
        String space = properties.containsKey("target") ? properties.get("target") : this.targetProperties.getDefaultSpace();
        return this.operations.spaces().get(org.cloudfoundry.operations.spaces.GetSpaceRequest.builder().name(space).build()).map(SpaceDetail::getId);
    }

    private String getDomainId(String domain, List<Domain> domains) {
        if (domain == null) {
            return this.getDefaultDomainId(domains);
        }
        return domains.stream().filter(d -> d.getName().equals(domain)).findFirst().orElseThrow(() -> new RuntimeException("Non existing domain")).getId();
    }

    private String getDefaultDomainId(List<Domain> domains) {
        return domains.stream().filter(d -> !"internal".equals(d.getType())).findFirst().orElseThrow(RuntimeException::new).getId();
    }

    private Mono<GetDeploymentResponse> waitForDeploymentDeployed(String deploymentId) {
        return this.client.deploymentsV3().get(GetDeploymentRequest.builder().deploymentId(deploymentId).build()).filter(this::deploymentFinished).repeatWhenEmpty(this.getExponentialBackOff(this.getDeploymentTimeout())).doOnRequest(l -> LOG.debug("Waiting for deployment to complete. deploymentId={}", (Object)deploymentId)).doOnSuccess(response -> {
            LOG.info("Success waiting for deployment to complete. deploymentId={}", (Object)deploymentId);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error waiting for deployment to complete. deploymentId=%s, error=%s", deploymentId, e.getMessage()), e));
    }

    private boolean deploymentFinished(GetDeploymentResponse p) {
        if (p.getState() != null) {
            return p.getState().equals((Object)DeploymentState.DEPLOYED);
        }
        return p.getStatus().getValue().equals((Object)DeploymentStatusValue.FINALIZED) && p.getStatus().getReason().equals((Object)DeploymentStatusReason.DEPLOYED);
    }

    private Mono<CreateDeploymentResponse> createDeployment(String dropletId, String applicationId) {
        return this.client.deploymentsV3().create(CreateDeploymentRequest.builder().droplet(Relationship.builder().id(dropletId).build()).relationships(DeploymentRelationships.builder().app(ToOneRelationship.builder().data(Relationship.builder().id(applicationId).build()).build()).build()).build()).doOnRequest(l -> LOG.debug("Creating deployment for application. applicationId={}", (Object)applicationId)).doOnSuccess(response -> {
            LOG.info("Success creating deployment for application. applicationId={}", (Object)applicationId);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error creating deployment for application. applicationId=%s, error=%s", applicationId, e.getMessage()), e));
    }

    private Mono<GetBuildResponse> waitForBuildStaged(String buildId) {
        return this.client.builds().get(GetBuildRequest.builder().buildId(buildId).build()).filter(p -> p.getState().equals((Object)BuildState.STAGED)).repeatWhenEmpty(this.getExponentialBackOff(this.getStagingTimeout())).doOnRequest(l -> LOG.debug("Waiting for build to stage. buildId={}", (Object)buildId)).doOnSuccess(response -> {
            LOG.info("Success waiting for build to stage. buildId={}", (Object)buildId);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error waiting for build to stage. buildId=%s, error=%s", buildId, e.getMessage()), e));
    }

    private Mono<String> createBuildForPackage(String packageId) {
        return this.client.builds().create(CreateBuildRequest.builder().getPackage(Relationship.builder().id(packageId).build()).build()).map(CreateBuildResponse::getId).doOnRequest(l -> LOG.debug("Creating build for package. packageId={}", (Object)packageId)).doOnSuccess(response -> {
            LOG.info("Success creating build for package. packageId={}", (Object)packageId);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error creating build package. packageId=%s, error=%s", packageId, e.getMessage()), e));
    }

    private Mono<GetPackageResponse> waitForPackageReady(String packageId) {
        return this.client.packages().get(GetPackageRequest.builder().packageId(packageId).build()).filter(p -> p.getState().equals((Object)PackageState.READY)).repeatWhenEmpty(this.getExponentialBackOff(DEFAULT_PLATFORM_OPERATION_DURATION)).doOnRequest(l -> LOG.debug("Waiting for package ready. packageId={}", (Object)packageId)).doOnSuccess(response -> {
            LOG.info("Success waiting for package ready. packageId={}", (Object)packageId);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error waiting for package ready. packageId=%s, error=%s", packageId, e.getMessage()), e));
    }

    private Mono<UploadPackageResponse> uploadPackage(org.springframework.cloud.appbroker.deployer.deployer.UpdateApplicationRequest request, String packageId) {
        try {
            return this.client.packages().upload(UploadPackageRequest.builder().packageId(packageId).bits(Paths.get(this.getAppResource(request.getPath()).getURI())).build()).doOnRequest(l -> {
                LOG.info("Uploading package. packageId={}", (Object)packageId);
                LOG.debug(REQUEST_LOG_TEMPLATE, (Object)request);
            }).doOnSuccess(response -> {
                LOG.info("Success uploading package. packageId={}", (Object)packageId);
                LOG.debug(RESPONSE_LOG_TEMPLATE, response);
            }).doOnError(e -> LOG.error(String.format("Error uploading package. packageId=%s, error=%s", packageId, e.getMessage()), e));
        }
        catch (IOException ex) {
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    private Mono<String> upgradeApplicationIfRequired(org.springframework.cloud.appbroker.deployer.deployer.UpdateApplicationRequest request, String applicationId) {
        if (request.getProperties().containsKey("upgrade")) {
            return this.createPackageForApplication(applicationId).map(CreatePackageResponse::getId).flatMap(packageId -> this.uploadPackage(request, (String)packageId)).map(UploadPackageResponse::getId).flatMap(packageId -> this.waitForPackageReady((String)packageId).map(org.cloudfoundry.client.v3.Resource::getId));
        }
        return this.getPackageForApplication(applicationId);
    }

    private Mono<String> updateApplication(org.springframework.cloud.appbroker.deployer.deployer.UpdateApplicationRequest request, String applicationId) {
        Map<String, Object> environmentVariables = this.getApplicationEnvironment(request.getProperties(), request.getEnvironment(), request.getServiceInstanceId());
        Map properties = request.getProperties();
        return this.updateStackIfPresent(request, applicationId).then(this.client.applicationsV2().update(org.cloudfoundry.client.v2.applications.UpdateApplicationRequest.builder().applicationId(applicationId).instances(this.instances(properties)).diskQuota(this.diskQuota(properties)).memory(this.memory(properties)).putAllEnvironmentJsons(environmentVariables).build()).doOnRequest(l -> LOG.debug("Updating environment. applicationId={}", (Object)applicationId)).doOnSuccess(response -> {
            LOG.info("Success updating environment. applicationId={}", (Object)applicationId);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error updating environment. applicationId=%s, error=%s", applicationId, e.getMessage()), e))).thenReturn((Object)applicationId);
    }

    private Mono<String> updateStackIfPresent(org.springframework.cloud.appbroker.deployer.deployer.UpdateApplicationRequest request, String applicationId) {
        if (!request.getProperties().containsKey("upgrade") || !StringUtils.hasText((String)this.defaultDeploymentProperties.getStack())) {
            return Mono.just((Object)applicationId);
        }
        String stackName = this.defaultDeploymentProperties.getStack();
        return this.client.applicationsV3().update(UpdateApplicationRequest.builder().applicationId(applicationId).lifecycle(Lifecycle.builder().type(LifecycleType.BUILDPACK).data((LifecycleData)BuildpackData.builder().stack(stackName).build()).build()).build()).thenReturn((Object)applicationId);
    }

    private Mono<String> getPackageForApplication(String applicationId) {
        return this.client.applicationsV3().listPackages(ListApplicationPackagesRequest.builder().applicationId(applicationId).state(PackageState.READY).build()).doOnRequest(l -> LOG.debug("Getting application package. applicationId={}", (Object)applicationId)).doOnSuccess(response -> {
            LOG.info("Success getting application package. applicationId={}", (Object)applicationId);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error getting application package. applicationId=%s, error=%s", applicationId, e.getMessage()), e)).map(ListApplicationPackagesResponse::getResources).map(this::getLastUpdatedPackageId);
    }

    private String getLastUpdatedPackageId(List<PackageResource> packageResources) {
        return packageResources.stream().min((h1, h2) -> Instant.parse(h2.getUpdatedAt()).compareTo(Instant.parse(h1.getUpdatedAt()))).orElse(packageResources.get(0)).getId();
    }

    private Mono<CreatePackageResponse> createPackageForApplication(String applicationId) {
        return this.client.packages().create(CreatePackageRequest.builder().relationships(PackageRelationships.builder().application(ToOneRelationship.builder().data(Relationship.builder().id(applicationId).build()).build()).build()).type(PackageType.BITS).build()).doOnRequest(l -> LOG.debug("Creating package. applicationId={}", (Object)applicationId)).doOnSuccess(response -> {
            LOG.info("Success creating package. applicationId={}", (Object)applicationId);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error creating package. applicationId=%s, error=%s", applicationId, e.getMessage()), e));
    }

    private Duration getStagingTimeout() {
        if (this.targetProperties.getStagingTimeout() == null) {
            return DEFAULT_PLATFORM_OPERATION_DURATION;
        }
        return Duration.ofMinutes(this.targetProperties.getStagingTimeout());
    }

    private Duration getDeploymentTimeout() {
        if (this.targetProperties.getDeploymentTimeout() == null) {
            return DEFAULT_PLATFORM_OPERATION_DURATION;
        }
        return Duration.ofMinutes(this.targetProperties.getDeploymentTimeout());
    }

    private Function<Flux<Long>, Publisher<?>> getExponentialBackOff(Duration timeout) {
        return DelayUtils.exponentialBackOff((Duration)Duration.ofSeconds(2L), (Duration)Duration.ofMinutes(5L), (Duration)timeout);
    }

    private Mono<Void> pushApplication(DeployApplicationRequest request, Map<String, String> deploymentProperties, Resource appResource) {
        Mono<Void> requestPushApplication;
        ApplicationManifest manifest = this.buildAppManifest(request, deploymentProperties, appResource);
        LOG.debug("Pushing app manifest. manifest={}", (Object)manifest.toString());
        PushApplicationManifestRequest applicationManifestRequest = PushApplicationManifestRequest.builder().manifest(manifest).stagingTimeout(this.defaultDeploymentProperties.getStagingTimeout()).startupTimeout(this.defaultDeploymentProperties.getStartupTimeout()).noStart(Boolean.valueOf(this.start(deploymentProperties) == false)).build();
        if (deploymentProperties.containsKey("target")) {
            String space = deploymentProperties.get("target");
            requestPushApplication = this.pushManifestInSpace(applicationManifestRequest, space);
        } else {
            requestPushApplication = this.pushManifest(applicationManifestRequest);
        }
        return requestPushApplication.doOnSuccess(v -> LOG.info("Success pushing app manifest. appName={}", (Object)request.getName())).doOnError(e -> LOG.error(String.format("Error pushing app manifest. appName=%s, error=%s", request.getName(), e.getMessage()), e));
    }

    private ApplicationManifest buildAppManifest(DeployApplicationRequest request, Map<String, String> deploymentProperties, Resource appResource) {
        ApplicationManifest.Builder manifest = ApplicationManifest.builder().name(request.getName()).path(this.getApplication(appResource)).environmentVariables(this.getEnvironmentVariables(deploymentProperties, request.getEnvironment(), request.getServiceInstanceId())).services((Iterable)request.getServices()).instances(this.instances(deploymentProperties)).memory(this.memory(deploymentProperties)).stack(this.stack(deploymentProperties)).disk(this.diskQuota(deploymentProperties)).healthCheckType(this.healthCheck(deploymentProperties)).healthCheckHttpEndpoint(this.healthCheckEndpoint(deploymentProperties)).timeout(this.healthCheckTimeout(deploymentProperties)).noRoute(this.toggleNoRoute(deploymentProperties));
        Optional.ofNullable(this.routePath(deploymentProperties)).ifPresent(arg_0 -> ((ApplicationManifest.Builder)manifest).routePath(arg_0));
        if (this.routes(deploymentProperties).isEmpty()) {
            Optional.ofNullable(this.host(deploymentProperties)).ifPresent(arg_0 -> ((ApplicationManifest.Builder)manifest).host(arg_0));
            Optional.ofNullable(this.domain(deploymentProperties)).ifPresent(arg_0 -> ((ApplicationManifest.Builder)manifest).domain(arg_0));
            if (!this.domains(deploymentProperties).isEmpty()) {
                this.domains(deploymentProperties).forEach(arg_0 -> ((ApplicationManifest.Builder)manifest).domain(arg_0));
            }
        } else {
            Set routes = this.routes(deploymentProperties).stream().map(r -> Route.builder().route(r).build()).collect(Collectors.toSet());
            manifest.routes(routes);
        }
        if (this.getDockerImage(appResource) == null) {
            manifest.buildpack(this.buildpack(deploymentProperties));
            String buildpacks = this.buildpacks(deploymentProperties);
            if (StringUtils.hasText((String)buildpacks)) {
                manifest.buildpacks(Arrays.asList(buildpacks.split(",")));
            }
        } else {
            manifest.docker(Docker.builder().image(this.getDockerImage(appResource)).build());
        }
        return manifest.build();
    }

    private Mono<Void> pushManifest(PushApplicationManifestRequest request) {
        return this.operations.applications().pushManifest(request);
    }

    private Mono<Void> pushManifestInSpace(PushApplicationManifestRequest request, String spaceName) {
        return this.createSpace(spaceName).then(this.operationsUtils.getOperationsForSpace(spaceName)).flatMap(cfOperations -> cfOperations.applications().pushManifest(request));
    }

    private Mono<String> createSpace(String spaceName) {
        return this.getSpaceId(spaceName).switchIfEmpty(Mono.justOrEmpty((Object)this.targetProperties.getDefaultOrg()).flatMap(orgName -> this.getOrganizationId((String)orgName).flatMap(orgId -> this.client.spaces().create(CreateSpaceRequest.builder().organizationId(orgId).name(spaceName).build()).doOnSuccess(response -> {
            LOG.info("Success creating space. spaceName={}", (Object)spaceName);
            LOG.debug(RESPONSE_LOG_TEMPLATE, response);
        }).doOnError(e -> LOG.error(String.format("Error creating space. spaceName=%s, error=%s", spaceName, e.getMessage()), e)).onErrorResume(e -> Mono.empty()).map(response -> response.getMetadata().getId()).flatMap(spaceId -> this.addSpaceDeveloperRoleForCurrentUser((String)orgName, spaceName, (String)spaceId).thenReturn(spaceId)))));
    }

    private Mono<Void> addSpaceDeveloperRoleForCurrentUser(String orgName, String spaceName, String spaceId) {
        return Mono.defer(() -> {
            if (StringUtils.hasText((String)this.targetProperties.getClientId())) {
                return this.client.spaces().associateDeveloper(AssociateSpaceDeveloperRequest.builder().spaceId(spaceId).developerId(this.targetProperties.getClientId()).build()).doOnSuccess(response -> {
                    LOG.info("Setting space developer role. spaceName={}", (Object)spaceName);
                    LOG.debug(RESPONSE_LOG_TEMPLATE, response);
                }).doOnError(e -> LOG.error(String.format("Error setting space developer role. spaceName=%s, error=%s", spaceName, e.getMessage()), e)).then();
            }
            if (StringUtils.hasText((String)this.targetProperties.getUsername())) {
                return this.operations.userAdmin().setSpaceRole(SetSpaceRoleRequest.builder().spaceRole(SpaceRole.DEVELOPER).organizationName(orgName).spaceName(spaceName).username(this.targetProperties.getUsername()).build()).doOnSuccess(v -> LOG.info("Seting space developer role. spaceName={}", (Object)spaceName)).doOnError(e -> LOG.error(String.format("Error setting space developer role. spaceName=%s, error=%s", spaceName, e.getMessage()), e));
            }
            return Mono.empty();
        });
    }

    private Mono<String> getOrganizationId(String orgName) {
        return this.operations.organizations().get(OrganizationInfoRequest.builder().name(orgName).build()).map(OrganizationDetail::getId);
    }

    public Mono<UndeployApplicationResponse> undeploy(UndeployApplicationRequest request) {
        Mono<Void> requestDeleteApplication;
        LOG.trace("Undeploying application. request={}", (Object)request);
        String appName = request.getName();
        Map deploymentProperties = request.getProperties();
        if (deploymentProperties.containsKey("target")) {
            String space = (String)deploymentProperties.get("target");
            requestDeleteApplication = this.deleteApplicationInSpace(appName, space);
        } else {
            requestDeleteApplication = this.deleteApplication(appName);
        }
        return requestDeleteApplication.timeout(Duration.ofSeconds(this.defaultDeploymentProperties.getApiTimeout())).doOnSuccess(v -> LOG.info("Success undeploying application. appName={}", (Object)appName)).doOnError(this.logError(String.format("Error undeploying application. appName=%s", appName))).then(Mono.just((Object)UndeployApplicationResponse.builder().name(appName).build()));
    }

    private Mono<Void> deleteApplication(String name) {
        return this.operations.applications().delete(DeleteApplicationRequest.builder().deleteRoutes(Boolean.valueOf(this.defaultDeploymentProperties.isDeleteRoutes())).name(name).build());
    }

    private Mono<Void> deleteApplicationInSpace(String name, String spaceName) {
        return this.getSpaceId(spaceName).doOnError(e -> LOG.error(String.format("Unable to get space name. spaceName=%s, error=%s", spaceName, e.getMessage()), e)).then(this.operationsUtils.getOperationsForSpace(spaceName)).flatMap(cfOperations -> cfOperations.applications().delete(DeleteApplicationRequest.builder().deleteRoutes(Boolean.valueOf(this.defaultDeploymentProperties.isDeleteRoutes())).name(name).build()).doOnError(e -> LOG.error(String.format("Error deleting application. appName=%s, error=%s", name, e.getMessage()), e))).onErrorResume(e -> Mono.empty());
    }

    public Mono<DeleteBackingSpaceResponse> deleteBackingSpace(DeleteBackingSpaceRequest request) {
        String spaceName = request.getName();
        return this.getSpaceId(spaceName).doOnError(e -> LOG.error(String.format("Unable to get space name. spaceName=%s, error=%s", spaceName, e.getMessage()), e)).onErrorResume(e -> Mono.empty()).flatMap(spaceId -> this.client.spaces().delete(DeleteSpaceRequest.builder().spaceId(spaceId).recursive(Boolean.valueOf(true)).build())).doOnError(e -> LOG.error(String.format("Error deleting space. spaceName=%s, error=%s", spaceName, e.getMessage()), e)).thenReturn((Object)DeleteBackingSpaceResponse.builder().name(spaceName).build());
    }

    private Mono<String> getSpaceId(String spaceName) {
        return Mono.justOrEmpty((Object)this.targetProperties.getDefaultOrg()).flatMap(orgName -> this.getOrganizationId((String)orgName).flatMap(orgId -> PaginationUtils.requestClientV2Resources(page -> this.client.organizations().listSpaces(ListOrganizationSpacesRequest.builder().name(spaceName).organizationId(orgId).page(page).build())).filter(resource -> resource.getEntity().getName().equals(spaceName)).map(resource -> resource.getMetadata().getId()).next()));
    }

    private Map<String, Object> getEnvironmentVariables(Map<String, String> properties, Map<String, Object> environment, String serviceInstanceId) {
        Map<String, Object> envVariables = this.getApplicationEnvironment(properties, environment, serviceInstanceId);
        String javaOpts = this.javaOpts(properties);
        if (StringUtils.hasText((String)javaOpts)) {
            envVariables.put("JAVA_OPTS", javaOpts);
        }
        return envVariables;
    }

    private Map<String, Object> getApplicationEnvironment(Map<String, String> properties, Map<String, Object> environment, String serviceInstanceId) {
        Map<String, Object> applicationEnvironment = this.sanitizeApplicationEnvironment(environment);
        if (serviceInstanceId != null) {
            applicationEnvironment.put("spring.cloud.appbroker.service-instance-id", serviceInstanceId);
        }
        if (!applicationEnvironment.isEmpty() && this.useSpringApplicationJson(properties)) {
            try {
                String jsonEnvironment = OBJECT_MAPPER.writeValueAsString(applicationEnvironment);
                applicationEnvironment = new HashMap<String, Object>(1);
                applicationEnvironment.put("SPRING_APPLICATION_JSON", jsonEnvironment);
            }
            catch (JsonProcessingException ex) {
                throw new IllegalArgumentException("Error writing environment to SPRING_APPLICATION_JSON", ex);
            }
        }
        return applicationEnvironment;
    }

    private Map<String, Object> sanitizeApplicationEnvironment(Map<String, Object> environment) {
        HashMap<String, Object> applicationEnvironment = new HashMap<String, Object>(environment);
        Optional.ofNullable(applicationEnvironment.remove("server.port")).ifPresent(port -> LOG.warn("Ignoring 'server.port={}', as Cloud Foundry will assign a local dynamic port. Route to the app will use port 80.", port));
        return applicationEnvironment;
    }

    private boolean useSpringApplicationJson(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("use-spring-application-json")).map(Boolean::valueOf).orElse(this.defaultDeploymentProperties.isUseSpringApplicationJson());
    }

    private String domain(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("domain")).orElse(this.defaultDeploymentProperties.getDomain());
    }

    private Set<String> domains(Map<String, String> properties) {
        HashSet<String> domains = new HashSet<String>();
        domains.addAll(this.defaultDeploymentProperties.getDomains());
        domains.addAll(StringUtils.commaDelimitedListToSet((String)properties.get("domains")));
        return domains;
    }

    private ApplicationHealthCheck healthCheck(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("health-check")).map(this::toApplicationHealthCheck).orElse(this.defaultDeploymentProperties.getHealthCheck());
    }

    private ApplicationHealthCheck toApplicationHealthCheck(String raw) {
        try {
            return ApplicationHealthCheck.from((String)raw);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(String.format("Unsupported health-check value '%s'. Available values are %s", raw, StringUtils.arrayToCommaDelimitedString((Object[])ApplicationHealthCheck.values())), ex);
        }
    }

    private String healthCheckEndpoint(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("health-check-http-endpoint")).orElse(this.defaultDeploymentProperties.getHealthCheckHttpEndpoint());
    }

    private Integer healthCheckTimeout(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("health-check-timeout")).map(Integer::parseInt).orElse(this.defaultDeploymentProperties.getHealthCheckTimeout());
    }

    private Duration apiPollingTimeout(Map<String, String> properties) {
        return Duration.ofSeconds(Optional.ofNullable(properties.get("api-polling-timeout")).map(Long::parseLong).orElse(this.defaultDeploymentProperties.getApiPollingTimeout()));
    }

    private Integer instances(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("count")).map(Integer::parseInt).orElse(this.defaultDeploymentProperties.getCount());
    }

    private String host(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("host")).orElse(this.defaultDeploymentProperties.getHost());
    }

    private String routePath(Map<String, String> properties) {
        String routePath = properties.get("route-path");
        if (StringUtils.hasText((String)routePath) && routePath.charAt(0) != '/') {
            throw new IllegalArgumentException("Cloud Foundry routes must start with \"/\". Route passed = [" + routePath + "].");
        }
        return routePath;
    }

    private Set<String> routes(Map<String, String> properties) {
        HashSet<String> routes = new HashSet<String>();
        routes.addAll(this.defaultDeploymentProperties.getRoutes());
        routes.addAll(StringUtils.commaDelimitedListToSet((String)properties.get("routes")));
        return routes;
    }

    private Boolean toggleNoRoute(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("no-route")).map(Boolean::valueOf).orElse(null);
    }

    private Integer memory(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("memory")).map(ByteSizeUtils::parseToMebibytes).orElse(ByteSizeUtils.parseToMebibytes((String)this.defaultDeploymentProperties.getMemory()));
    }

    private Integer diskQuota(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("disk")).map(ByteSizeUtils::parseToMebibytes).orElse(ByteSizeUtils.parseToMebibytes((String)this.defaultDeploymentProperties.getDisk()));
    }

    private String buildpack(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("buildpack")).orElse(this.defaultDeploymentProperties.getBuildpack());
    }

    private String buildpacks(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("buildpacks")).orElse(this.defaultDeploymentProperties.getBuildpacks());
    }

    private String stack(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("stack")).orElse(this.defaultDeploymentProperties.getStack());
    }

    private String javaOpts(Map<String, String> properties) {
        return Optional.ofNullable(properties.get("javaOpts")).orElse(this.defaultDeploymentProperties.getJavaOpts());
    }

    private Boolean start(Map<String, String> deploymentProperties) {
        return Optional.ofNullable(deploymentProperties.get("start")).map(Boolean::valueOf).orElse(true);
    }

    private Predicate<Throwable> httpStatusNotFoundPredicate() {
        return t -> t instanceof AbstractCloudFoundryException && ((AbstractCloudFoundryException)t).getStatusCode() == HttpStatus.NOT_FOUND.value();
    }

    private String getDockerImage(Resource resource) {
        try {
            String uri = resource.getURI().toString();
            if (uri.startsWith("docker:")) {
                return uri.substring("docker:".length());
            }
            return null;
        }
        catch (IOException ex) {
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    private Resource getAppResource(String path) {
        return this.resourceLoader.getResource(path);
    }

    private Path getApplication(Resource resource) {
        try {
            if (resource.getURI().toString().startsWith("docker:")) {
                return null;
            }
            return resource.getFile().toPath();
        }
        catch (IOException ex) {
            throw Exceptions.propagate((Throwable)ex);
        }
    }

    public Mono<GetServiceInstanceResponse> getServiceInstance(org.springframework.cloud.appbroker.deployer.deployer.GetServiceInstanceRequest request) {
        return Mono.defer(() -> {
            if (StringUtils.hasText((String)request.getServiceInstanceId())) {
                return this.getServiceInstance(request.getServiceInstanceId()).flatMap(serviceInstanceEntity -> this.getSpace(serviceInstanceEntity.getSpaceId()).flatMap(spaceEntity -> this.getServiceInstance(serviceInstanceEntity.getName(), (SpaceEntity)spaceEntity)));
            }
            return this.operationsUtils.getOperations(request.getProperties()).flatMap(cfOperations -> cfOperations.services().getInstance(GetServiceInstanceRequest.builder().name(request.getName()).build()));
        }).map(serviceInstance -> GetServiceInstanceResponse.builder().name(serviceInstance.getName()).service(serviceInstance.getService()).plan(serviceInstance.getPlan()).build());
    }

    private Mono<ServiceInstance> getServiceInstance(String name, SpaceEntity spaceEntity) {
        return this.getOrganization(spaceEntity.getOrganizationId()).flatMap(organizationEntity -> this.operationsUtils.getOperationsForOrgAndSpace(organizationEntity.getName(), spaceEntity.getName()).flatMap(cfOperations -> cfOperations.services().getInstance(GetServiceInstanceRequest.builder().name(name).build())));
    }

    private Mono<ServiceInstanceEntity> getServiceInstance(String serviceInstanceId) {
        return this.client.serviceInstances().get(org.cloudfoundry.client.v2.serviceinstances.GetServiceInstanceRequest.builder().serviceInstanceId(serviceInstanceId).build()).map(ResourceUtils::getEntity);
    }

    private Mono<SpaceEntity> getSpace(String spaceId) {
        return this.client.spaces().get(GetSpaceRequest.builder().spaceId(spaceId).build()).map(ResourceUtils::getEntity);
    }

    private Mono<OrganizationEntity> getOrganization(String organizationId) {
        return this.client.organizations().get(GetOrganizationRequest.builder().organizationId(organizationId).build()).map(GetOrganizationResponse::getEntity);
    }

    public Mono<CreateServiceInstanceResponse> createServiceInstance(CreateServiceInstanceRequest request) {
        org.cloudfoundry.operations.services.CreateServiceInstanceRequest createServiceInstanceRequest = org.cloudfoundry.operations.services.CreateServiceInstanceRequest.builder().serviceInstanceName(request.getServiceInstanceName()).serviceName(request.getName()).planName(request.getPlan()).parameters(request.getParameters()).completionTimeout(this.apiPollingTimeout(request.getProperties())).build();
        Mono createServiceInstanceResponseMono = Mono.just((Object)CreateServiceInstanceResponse.builder().name(request.getServiceInstanceName()).build());
        if (request.getProperties().containsKey("target")) {
            return this.createSpace((String)request.getProperties().get("target")).then(this.operationsUtils.getOperations(request.getProperties()).flatMap(cfOperations -> cfOperations.services().createInstance(createServiceInstanceRequest).then(createServiceInstanceResponseMono)));
        }
        return this.operations.services().createInstance(createServiceInstanceRequest).then(createServiceInstanceResponseMono);
    }

    public Mono<UpdateServiceInstanceResponse> updateServiceInstance(UpdateServiceInstanceRequest request) {
        return this.operationsUtils.getOperations(request.getProperties()).flatMap(cfOperations -> this.rebindServiceInstanceIfNecessary(request, (CloudFoundryOperations)cfOperations).then(this.updateServiceInstanceIfNecessary(request, (CloudFoundryOperations)cfOperations)));
    }

    public Mono<DeleteServiceInstanceResponse> deleteServiceInstance(DeleteServiceInstanceRequest request) {
        String serviceInstanceName = request.getServiceInstanceName();
        Map deploymentProperties = request.getProperties();
        Mono requestDeleteServiceInstance = deploymentProperties.containsKey("target") ? this.operationsUtils.getOperations(deploymentProperties).flatMap(cfOperations -> this.unbindServiceInstance(serviceInstanceName, (CloudFoundryOperations)cfOperations).then(this.deleteServiceInstance(serviceInstanceName, (CloudFoundryOperations)cfOperations, deploymentProperties))) : this.unbindServiceInstance(serviceInstanceName, this.operations).then(this.deleteServiceInstance(serviceInstanceName, this.operations, deploymentProperties));
        return requestDeleteServiceInstance.doOnSuccess(v -> LOG.info("Success deleting service instance. serviceInstanceName={}", (Object)serviceInstanceName)).doOnError(this.logError(String.format("Error deleting service instance. serviceInstanceName=%s", serviceInstanceName))).thenReturn((Object)DeleteServiceInstanceResponse.builder().name(serviceInstanceName).build());
    }

    private Mono<Void> deleteServiceInstance(String serviceInstanceName, CloudFoundryOperations cloudFoundryOperations, Map<String, String> deploymentProperties) {
        return cloudFoundryOperations.services().deleteInstance(org.cloudfoundry.operations.services.DeleteServiceInstanceRequest.builder().name(serviceInstanceName).completionTimeout(this.apiPollingTimeout(deploymentProperties)).build()).doOnError(e -> LOG.error(String.format("Error deleting service instance. serviceInstanceName=%s, error=%s", serviceInstanceName, e.getMessage()), e)).onErrorResume(e -> Mono.empty());
    }

    private Mono<Void> unbindServiceInstance(String serviceInstanceName, CloudFoundryOperations cloudFoundryOperations) {
        return cloudFoundryOperations.services().getInstance(GetServiceInstanceRequest.builder().name(serviceInstanceName).build()).doOnError(e -> LOG.error(String.format("Error getting service instance. serviceInstanceName=%s, error=%s", serviceInstanceName, e.getMessage()), e)).onErrorResume(e -> Mono.empty()).map(ServiceInstance::getApplications).flatMap(applications -> Flux.fromIterable((Iterable)applications).flatMap(application -> cloudFoundryOperations.services().unbind(UnbindServiceInstanceRequest.builder().applicationName(application).serviceInstanceName(serviceInstanceName).build())).doOnError(e -> LOG.error(String.format("Error unbinding service instance. serviceInstanceName=%s, error=%s", serviceInstanceName, e.getMessage()), e)).onErrorResume(e -> Mono.empty()).then(Mono.empty()));
    }

    private Mono<Void> rebindServiceInstance(String serviceInstanceName, CloudFoundryOperations cloudFoundryOperations) {
        return cloudFoundryOperations.services().getInstance(GetServiceInstanceRequest.builder().name(serviceInstanceName).build()).map(ServiceInstance::getApplications).flatMap(applications -> Flux.fromIterable((Iterable)applications).flatMap(application -> cloudFoundryOperations.services().unbind(UnbindServiceInstanceRequest.builder().applicationName(application).serviceInstanceName(serviceInstanceName).build()).then(cloudFoundryOperations.services().bind(BindServiceInstanceRequest.builder().applicationName(application).serviceInstanceName(serviceInstanceName).build()))).then(Mono.empty()));
    }

    private Mono<Void> rebindServiceInstanceIfNecessary(UpdateServiceInstanceRequest request, CloudFoundryOperations cloudFoundryOperations) {
        if (request.isRebindOnUpdate()) {
            return this.rebindServiceInstance(request.getServiceInstanceName(), cloudFoundryOperations);
        }
        return Mono.empty();
    }

    private Mono<UpdateServiceInstanceResponse> updateServiceInstanceIfNecessary(UpdateServiceInstanceRequest request, CloudFoundryOperations cloudFoundryOperations) {
        if (request.getParameters() == null || request.getParameters().isEmpty()) {
            return Mono.empty();
        }
        String serviceInstanceName = request.getServiceInstanceName();
        return cloudFoundryOperations.services().updateInstance(org.cloudfoundry.operations.services.UpdateServiceInstanceRequest.builder().serviceInstanceName(serviceInstanceName).completionTimeout(this.apiPollingTimeout(request.getProperties())).parameters(request.getParameters()).build()).then(Mono.just((Object)UpdateServiceInstanceResponse.builder().name(serviceInstanceName).build()));
    }

    private Consumer<Throwable> logError(String msg) {
        return e -> {
            if (e instanceof UnknownCloudFoundryException) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(msg + "\nUnknownCloudFoundryException encountered, whose payload follows:\n" + ((UnknownCloudFoundryException)e).getPayload(), e);
                }
            } else if (LOG.isErrorEnabled()) {
                LOG.error(msg, e);
            }
        };
    }
}

