/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.appbroker.autoconfigure;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import java.util.stream.Stream;
import org.cloudfoundry.client.CloudFoundryClient;
import org.cloudfoundry.doppler.DopplerClient;
import org.cloudfoundry.logcache.v1.LogCacheClient;
import org.cloudfoundry.operations.CloudFoundryOperations;
import org.cloudfoundry.operations.DefaultCloudFoundryOperations;
import org.cloudfoundry.reactor.ConnectionContext;
import org.cloudfoundry.reactor.DefaultConnectionContext;
import org.cloudfoundry.reactor.TokenProvider;
import org.cloudfoundry.reactor.client.ReactorCloudFoundryClient;
import org.cloudfoundry.reactor.doppler.ReactorDopplerClient;
import org.cloudfoundry.reactor.logcache.v1.ReactorLogCacheClient;
import org.cloudfoundry.reactor.tokenprovider.ClientCredentialsGrantTokenProvider;
import org.cloudfoundry.reactor.tokenprovider.PasswordGrantTokenProvider;
import org.cloudfoundry.reactor.uaa.ReactorUaaClient;
import org.cloudfoundry.uaa.UaaClient;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.appbroker.deployer.AppDeployer;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryAppDeployer;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryAppManager;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryDeploymentProperties;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryOAuth2Client;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryOperationsUtils;
import org.springframework.cloud.appbroker.deployer.cloudfoundry.CloudFoundryTargetProperties;
import org.springframework.cloud.appbroker.manager.AppManager;
import org.springframework.cloud.appbroker.oauth2.OAuth2Client;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnProperty(value={"spring.cloud.appbroker.deployer.cloudfoundry.api-host"})
@EnableConfigurationProperties
public class CloudFoundryAppDeployerAutoConfiguration {
    protected static final String PROPERTY_PREFIX = "spring.cloud.appbroker.deployer.cloudfoundry";

    @Bean
    @ConfigurationProperties(value="spring.cloud.appbroker.deployer.cloudfoundry.properties")
    public CloudFoundryDeploymentProperties cloudFoundryDeploymentProperties() {
        return new CloudFoundryDeploymentProperties();
    }

    @Bean
    @ConfigurationProperties(value="spring.cloud.appbroker.deployer.cloudfoundry")
    public CloudFoundryTargetProperties cloudFoundryTargetProperties() {
        return new CloudFoundryTargetProperties();
    }

    @Bean
    public AppDeployer cloudFoundryAppDeployer(CloudFoundryDeploymentProperties deploymentProperties, CloudFoundryOperations cloudFoundryOperations, CloudFoundryClient cloudFoundryClient, CloudFoundryOperationsUtils operationsUtils, CloudFoundryTargetProperties targetProperties, ResourceLoader resourceLoader) {
        return new CloudFoundryAppDeployer(deploymentProperties, cloudFoundryOperations, cloudFoundryClient, operationsUtils, targetProperties, resourceLoader);
    }

    @Bean
    public AppManager cloudFoundryAppManager(CloudFoundryOperationsUtils cloudFoundryOperationsUtils) {
        return new CloudFoundryAppManager(cloudFoundryOperationsUtils);
    }

    @Bean
    public OAuth2Client cloudFoundryOAuth2Client(@UaaClientQualifier UaaClient uaaClient) {
        return new CloudFoundryOAuth2Client(uaaClient);
    }

    @Bean
    public ReactorCloudFoundryClient cloudFoundryClient(@ConnectionContextQualifier ConnectionContext connectionContext, @TokenQualifier TokenProvider tokenProvider) {
        return ReactorCloudFoundryClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
    }

    @Bean
    public CloudFoundryOperations cloudFoundryOperations(CloudFoundryTargetProperties properties, CloudFoundryClient client, DopplerClient dopplerClient, @UaaClientQualifier UaaClient uaaClient) {
        return DefaultCloudFoundryOperations.builder().cloudFoundryClient(client).dopplerClient(dopplerClient).uaaClient(uaaClient).organization(properties.getDefaultOrg()).space(properties.getDefaultSpace()).build();
    }

    @Bean
    public CloudFoundryOperationsUtils cloudFoundryOperationsUtils(CloudFoundryOperations operations) {
        return new CloudFoundryOperationsUtils(operations);
    }

    @Bean
    @ConnectionContextQualifier
    public DefaultConnectionContext connectionContext(CloudFoundryTargetProperties properties) {
        return DefaultConnectionContext.builder().apiHost(properties.getApiHost()).port(Optional.ofNullable(properties.getApiPort())).skipSslValidation(properties.isSkipSslValidation()).secure(properties.isSecure()).build();
    }

    @Bean
    public ReactorDopplerClient dopplerClient(@ConnectionContextQualifier ConnectionContext connectionContext, @TokenQualifier TokenProvider tokenProvider) {
        return ReactorDopplerClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
    }

    @Bean
    public LogCacheClient logCacheClient(@ConnectionContextQualifier ConnectionContext connectionContext, @TokenQualifier TokenProvider tokenProvider) {
        return ReactorLogCacheClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
    }

    @TokenQualifier
    @Bean
    public TokenProvider uaaTokenProvider(CloudFoundryTargetProperties properties) {
        boolean isClientIdAndSecretSet = Stream.of(properties.getClientId(), properties.getClientSecret()).allMatch(StringUtils::hasText);
        boolean isUsernameAndPasswordSet = Stream.of(properties.getUsername(), properties.getPassword()).allMatch(StringUtils::hasText);
        if (isClientIdAndSecretSet && isUsernameAndPasswordSet) {
            throw new IllegalStateException(String.format("(%1$s.client_id / %1$s.client_secret) must not be set when\n(%1$s.username / %1$s.password) are also set", PROPERTY_PREFIX));
        }
        if (isClientIdAndSecretSet) {
            return ClientCredentialsGrantTokenProvider.builder().clientId(properties.getClientId()).clientSecret(properties.getClientSecret()).identityZoneSubdomain(properties.getIdentityZoneSubdomain()).build();
        }
        if (isUsernameAndPasswordSet) {
            return PasswordGrantTokenProvider.builder().password(properties.getPassword()).username(properties.getUsername()).build();
        }
        throw new IllegalStateException(String.format("Either (%1$s.client_id and %1$s.client_secret) or\n(%1$s.username and %1$s.password) properties must be set", PROPERTY_PREFIX));
    }

    @UaaClientQualifier
    @Bean
    public ReactorUaaClient uaaClient(@ConnectionContextQualifier ConnectionContext connectionContext, @TokenQualifier TokenProvider tokenProvider) {
        return ReactorUaaClient.builder().connectionContext(connectionContext).tokenProvider(tokenProvider).build();
    }

    @Qualifier
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConnectionContextQualifier {
        public String value() default "appBrokerConnectionContextQualifier";
    }

    @Qualifier
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface UaaClientQualifier {
        public String value() default "appBrokerUaaClientQualifier";
    }

    @Qualifier
    @Target(value={ElementType.FIELD, ElementType.PARAMETER, ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface TokenQualifier {
        public String value() default "appBrokerTokenProvider";
    }
}

