/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.sentinel;

import com.alibaba.csp.sentinel.adapter.servlet.CommonFilter;
import java.util.ArrayList;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.alibaba.sentinel.SentinelProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnProperty(name={"spring.cloud.sentinel.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SentinelProperties.class})
public class SentinelWebAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SentinelWebAutoConfiguration.class);
    @Autowired
    private SentinelProperties properties;

    @Bean
    public FilterRegistrationBean servletRequestListener() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        SentinelProperties.Filter filterConfig = this.properties.getFilter();
        if (null == filterConfig) {
            filterConfig = new SentinelProperties.Filter();
            this.properties.setFilter(filterConfig);
        }
        if (filterConfig.getUrlPatterns() == null || filterConfig.getUrlPatterns().isEmpty()) {
            ArrayList<String> defaultPatterns = new ArrayList<String>();
            defaultPatterns.add("/*");
            filterConfig.setUrlPatterns(defaultPatterns);
        }
        registration.addUrlPatterns(filterConfig.getUrlPatterns().toArray(new String[0]));
        CommonFilter filter = new CommonFilter();
        registration.setFilter((Filter)filter);
        registration.setOrder(filterConfig.getOrder());
        logger.info("[Sentinel Starter] register Sentinel with urlPatterns: {}.", filterConfig.getUrlPatterns());
        return registration;
    }
}

