/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.wrapper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThinJarWrapper {
    public static final String THIN_ROOT = "thin.root";
    public static final String THIN_LIBRARY = "thin.library";
    public static final String THIN_ARCHIVE = "thin.archive";
    public static final String THIN_REPO = "thin.repo";
    public static final String THIN_LAUNCHER = "thin.launcher";
    private static final String DEFAULT_LAUNCHER_CLASS = "org.springframework.boot.loader.thin.ThinJarLauncher";
    private static final String DEFAULT_LIBRARY = "org.springframework.boot.experimental:spring-boot-thin-launcher:jar:exec:1.0.0.RELEASE";
    private Library library = this.library();

    public static void main(String[] args) throws Exception {
        Class<ThinJarWrapper> launcher = ThinJarWrapper.class;
        if (ThinJarWrapper.getProperty(THIN_ARCHIVE) == null) {
            System.setProperty(THIN_ARCHIVE, launcher.getProtectionDomain().getCodeSource().getLocation().toURI().toString());
        }
        new ThinJarWrapper().launch(args);
    }

    ThinJarWrapper() {
    }

    Library library() {
        String coordinates = ThinJarWrapper.getProperty(THIN_LIBRARY);
        return new Library(coordinates == null ? DEFAULT_LIBRARY : coordinates);
    }

    private void launch(String ... args) throws Exception {
        ClassLoader classLoader = this.getClassLoader();
        Class<?> launcher = classLoader.loadClass(this.launcherClass());
        this.findMainMethod(launcher).invoke(null, new Object[]{args});
    }

    private String launcherClass() {
        String launcher = ThinJarWrapper.getProperty(THIN_LAUNCHER);
        return launcher == null ? DEFAULT_LAUNCHER_CLASS : launcher;
    }

    private Method findMainMethod(Class<?> launcher) throws NoSuchMethodException {
        return launcher.getMethod("main", String[].class);
    }

    private ClassLoader getClassLoader() throws Exception {
        URL[] urls = this.getUrls();
        URLClassLoader classLoader = new URLClassLoader(urls, ThinJarWrapper.class.getClassLoader().getParent());
        Thread.currentThread().setContextClassLoader(classLoader);
        return classLoader;
    }

    private URL[] getUrls() throws Exception {
        this.library.download(this.mavenLocal(), this.mavenLocal(null));
        return new URL[]{new File(String.valueOf(this.mavenLocal()) + this.library.getPath()).toURI().toURL()};
    }

    String mavenLocal() {
        return this.mavenLocal(ThinJarWrapper.getProperty(THIN_ROOT));
    }

    private String mavenLocal(String home) {
        return String.valueOf(this.mvnHome(home)) + "/repository";
    }

    private String mvnHome(String home) {
        if (home != null) {
            return home;
        }
        return String.valueOf(this.home()) + "/.m2";
    }

    private String home() {
        String home = ThinJarWrapper.getProperty("user.home");
        return home == null ? "." : home;
    }

    static String getProperty(String key) {
        if (System.getProperty(key) != null) {
            return System.getProperty(key);
        }
        return System.getenv(key.replace(".", "_").toUpperCase());
    }

    static class Library {
        private String coordinates;
        private String groupId;
        private String artifactId;
        private String version;
        private String classifier;
        private String extension;

        public Library(String coordinates) {
            this.coordinates = coordinates;
            Pattern p = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?:([^: ]+)");
            Matcher m = p.matcher(coordinates);
            if (!m.matches()) {
                throw new IllegalArgumentException("Bad artifact coordinates " + coordinates + ", expected format is <groupId>:<artifactId>[:<extension>[:<classifier>]]:<version>");
            }
            this.groupId = m.group(1);
            this.artifactId = m.group(2);
            this.extension = Library.get(m.group(4), "jar");
            this.classifier = Library.get(m.group(6), null);
            this.version = m.group(7);
        }

        private static String get(String value, String defaultValue) {
            return value == null || value.length() <= 0 ? defaultValue : value;
        }

        public void download(String path, String defaultPath) {
            File target;
            if (path == null) {
                path = defaultPath;
            }
            if (!(target = new File(String.valueOf(path) + this.getPath())).exists()) {
                if (!target.getParentFile().exists() && !target.getParentFile().mkdirs()) {
                    throw new IllegalStateException("Cannot create directory launcher at " + target);
                }
                boolean result = false;
                if (!defaultPath.equals(path)) {
                    result = this.downloadFromUrl(this.getUrl(defaultPath), target);
                }
                if (!result) {
                    result = this.downloadFromUrl(this.repo(), target);
                }
                if (!result) {
                    throw new IllegalStateException("Cannot download library for launcher " + this.coordinates);
                }
            }
        }

        private String getUrl(String file) {
            if (!file.startsWith(".") && !file.startsWith("/")) {
                file = "./" + file;
            }
            return "file://" + file;
        }

        private boolean downloadFromUrl(String repo, File target) {
            InputStream input = null;
            OutputStream output = null;
            try {
                input = new URL(String.valueOf(repo) + this.getPath()).openStream();
                output = new FileOutputStream(target);
                byte[] bytes = new byte[4096];
                int count = input.read(bytes);
                while (count > 0) {
                    output.write(bytes, 0, count);
                    count = input.read(bytes);
                }
                return true;
            }
            catch (Exception exception) {
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return false;
        }

        private String repo() {
            String repo = ThinJarWrapper.getProperty(ThinJarWrapper.THIN_REPO);
            return repo != null ? repo : "https://repo.spring.io/libs-snapshot";
        }

        public String getCoordinates() {
            return this.coordinates;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getPath() {
            return "/" + this.groupId.replace(".", "/") + "/" + this.artifactId + "/" + this.version + "/" + this.artifactId + "-" + this.version + (this.classifier != null ? "-" + this.classifier : "") + "." + this.extension;
        }
    }
}

