/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.launcher.deployer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.cloud.deployer.spi.app.AppDeployer;
import org.springframework.cloud.deployer.spi.app.AppStatus;
import org.springframework.cloud.deployer.spi.app.DeploymentState;
import org.springframework.cloud.deployer.spi.core.AppDefinition;
import org.springframework.cloud.deployer.spi.core.AppDeploymentRequest;
import org.springframework.cloud.launcher.deployer.DeployerApplication;
import org.springframework.cloud.launcher.deployer.DeployerProperties;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.OrderComparator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class Deployer {
    private static final Logger logger = LoggerFactory.getLogger(Deployer.class);
    public static final String DIRECTORY_NAME = ".spring-cloud";
    final AppDeployer deployer;
    final ResourceLoader resourceLoader;
    final DeployerProperties properties;
    final ConfigurableEnvironment environment;
    private Map<String, DeploymentState> deployed = new ConcurrentHashMap<String, DeploymentState>();

    public Deployer(AppDeployer deployer, ResourceLoader resourceLoader, DeployerProperties properties, ConfigurableEnvironment environment) {
        this.deployer = deployer;
        this.resourceLoader = resourceLoader;
        this.properties = properties;
        this.environment = environment;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void deploy() {
        invalid = new ArrayList<String>();
        for (Iterator<Object> toDeploy : this.properties.getDeploy()) {
            if (this.properties.getDeployables().containsKey(toDeploy)) continue;
            invalid.add((String)toDeploy);
        }
        if (!invalid.isEmpty()) {
            Deployer.logger.error("Error starting 'spring cloud'.\n\nThe following are not valid: '" + StringUtils.collectionToCommaDelimitedString(invalid) + "'. Please check the name(s) and try again.\n" + "Valid choices are: " + StringUtils.collectionToCommaDelimitedString(this.properties.getDeployables().keySet()) + ".\n");
            return;
        }
        deployables = new ArrayList<DeployerProperties.Deployable>(this.properties.getDeployables().values());
        OrderComparator.sort(deployables);
        Deployer.logger.debug("Deployables {}", this.properties.getDeployables());
        for (DeployerProperties.Deployable deployable : deployables) {
            this.deployInternal(this.deployer, this.resourceLoader, deployable, this.properties, this.environment);
        }
        for (DeployerProperties.Deployable deployable : deployables) {
            if (!this.shouldDeploy(deployable, this.properties) || !StringUtils.hasText((String)deployable.getMessage())) continue;
            System.out.println("\n\n" + deployable.getName() + ": " + deployable.getMessage() + "\n");
        }
        if (this.deployed.isEmpty()) {
            System.out.println("\n\nNothing to deploy (see spring.cloud.launcher.deploy).\n");
            return;
        }
        System.out.println("\n\nType Ctrl-C to quit.\n");
        while (true) lbl-1000:
        // 5 sources

        {
            for (Map.Entry entry : this.deployed.entrySet()) {
                id = (String)entry.getKey();
                state = (DeploymentState)entry.getValue();
                if (state == (newState = (status = this.deployer.status(id)).getState())) continue;
                Deployer.logger.info("{} change status from {} to {}", new Object[]{id, state, newState});
                this.deployed.put(id, newState);
            }
            try {
                Thread.sleep(this.properties.getStatusSleepMillis());
                ** continue;
            }
            catch (InterruptedException e) {
                Deployer.logger.error("error sleeping", (Throwable)e);
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    @EventListener
    public void shutdown(ContextClosedEvent event) {
        logger.info("\n\nShutting down ...\n");
        for (String id : this.deployed.keySet()) {
            logger.info("Undeploying {}", (Object)id);
            this.deployer.undeploy(id);
        }
    }

    private String deployInternal(AppDeployer deployer, ResourceLoader resourceLoader, DeployerProperties.Deployable deployable, DeployerProperties properties, ConfigurableEnvironment environment) {
        if (!this.shouldDeploy(deployable, properties)) {
            return null;
        }
        logger.debug("getting resource {} = {}", (Object)deployable.getName(), (Object)deployable.getCoordinates());
        Resource resource = resourceLoader.getResource(deployable.getCoordinates());
        HashMap<String, String> appDefProps = new HashMap<String, String>();
        appDefProps.put("server.port", String.valueOf(deployable.getPort()));
        for (DeployerProperties.Deployable deployable2 : properties.getDeployables().values()) {
            if (this.shouldDeploy(deployable2.getName(), properties)) continue;
            appDefProps.putAll(deployable2.getDisabled());
        }
        for (DeployerProperties.Deployable deployable3 : properties.getDeployables().values()) {
            if (!this.shouldDeploy(deployable3.getName(), properties)) continue;
            appDefProps.putAll(deployable3.getEnabled());
        }
        appDefProps.putAll(deployable.getApplicationProperties());
        Map<String, String> map = this.extractProperties("/" + deployable.getName() + ".yml");
        for (String key : map.keySet()) {
            appDefProps.put(key, map.get(key));
        }
        AppDefinition appDefinition = new AppDefinition(deployable.getName(), appDefProps);
        LinkedHashMap<String, String> deploymentProperties = new LinkedHashMap<String, String>();
        deploymentProperties.put("spring.cloud.deployer.group", "launcher");
        deploymentProperties.putAll(deployable.getProperties());
        AppDeploymentRequest request = new AppDeploymentRequest(appDefinition, resource, deploymentProperties);
        logger.debug("Deploying resource {} = {}", (Object)deployable.getName(), (Object)deployable.getCoordinates());
        logger.debug("AppDefinition Properties: {}", appDefProps);
        logger.debug("Deployment Properties: {}", deploymentProperties);
        String id = deployer.deploy(request);
        AppStatus appStatus = this.getAppStatus(deployer, id);
        if (deployable.isWaitUntilStarted()) {
            try {
                logger.info("\n\nWaiting for {} to start.\n", (Object)deployable.getName());
                while (appStatus.getState() != DeploymentState.deployed && appStatus.getState() != DeploymentState.failed) {
                    Thread.sleep(properties.getStatusSleepMillis());
                    appStatus = this.getAppStatus(deployer, id);
                    logger.trace("State of {} = {}", (Object)id, (Object)appStatus.getState());
                }
            }
            catch (Exception e) {
                logger.error("error updating status of " + id, (Throwable)e);
            }
        }
        logger.info("Status of {}: {}", (Object)id, (Object)appStatus);
        return id;
    }

    private boolean shouldDeploy(DeployerProperties.Deployable deployable, DeployerProperties properties) {
        return this.shouldDeploy(deployable.getName(), properties);
    }

    private boolean shouldDeploy(String name, DeployerProperties properties) {
        boolean deploy = properties.getDeploy().contains(name);
        logger.trace("shouldDeploy {} = {}", (Object)name, (Object)deploy);
        return deploy;
    }

    private AppStatus getAppStatus(AppDeployer deployer, String id) {
        AppStatus appStatus = deployer.status(id);
        this.deployed.put(id, appStatus.getState());
        return appStatus;
    }

    private Map<String, String> extractProperties(String path) {
        PropertySource<?> source = this.extractPropertySource(path);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (source instanceof EnumerablePropertySource) {
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            for (String name : enumerable.getPropertyNames()) {
                map.put(name, source.getProperty(name) == null ? null : source.getProperty(name).toString());
            }
        }
        return map;
    }

    private PropertySource<?> extractPropertySource(String path) {
        PropertySource<?> source = null;
        ClassPathResource resource = new ClassPathResource("config" + path, DeployerApplication.class);
        source = this.loadPropertySource((Resource)resource, path);
        if (source == null) {
            resource = new ClassPathResource(path, DeployerApplication.class);
            source = this.loadPropertySource((Resource)resource, path);
        }
        if (source == null) {
            resource = new FileSystemResource("config" + path);
            source = this.loadPropertySource((Resource)resource, path);
        }
        if (source == null) {
            resource = new FileSystemResource("." + path);
            source = this.loadPropertySource((Resource)resource, path);
        }
        if (source == null) {
            File springCloudDir;
            File home = this.getHomeFolder();
            File file = springCloudDir = home == null ? null : new File(home, DIRECTORY_NAME);
            if (logger.isDebugEnabled() && springCloudDir != null) {
                logger.debug("~/.spring-cloud directory: {}, exists: {}, isDir: {}", new Object[]{springCloudDir, springCloudDir.exists(), springCloudDir.isDirectory()});
            } else if (logger.isDebugEnabled()) {
                logger.debug("no ~/.spring-cloud directory");
            }
            if (springCloudDir != null && springCloudDir.exists() && springCloudDir.isDirectory()) {
                resource = new FileSystemResource(new File(springCloudDir, path));
                source = this.loadPropertySource((Resource)resource, path);
            }
        }
        return source;
    }

    protected File getHomeFolder() {
        String home = System.getProperty("user.home");
        if (StringUtils.hasLength((String)home)) {
            return new File(home);
        }
        return null;
    }

    private PropertySource<?> loadPropertySource(Resource resource, String path) {
        if (resource.exists()) {
            try {
                PropertySource source = new YamlPropertySourceLoader().load(path, resource, null);
                if (source != null) {
                    logger.info("Loaded YAML properties from: " + resource);
                }
                return source;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

