/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.system;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ApplicationHome {
    private final File source;
    private final File dir;

    public ApplicationHome() {
        this(null);
    }

    public ApplicationHome(Class<?> sourceClass) {
        this.source = this.findSource(sourceClass != null ? sourceClass : this.getStartClass());
        this.dir = this.findHomeDir(this.source);
    }

    private Class<?> getStartClass() {
        try {
            ClassLoader classLoader = this.getClass().getClassLoader();
            return this.getStartClass(classLoader.getResources("META-INF/MANIFEST.MF"));
        }
        catch (Exception ex) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Class<?> getStartClass(Enumeration<URL> manifestResources) {
        while (manifestResources.hasMoreElements()) {
            try {
                InputStream inputStream = manifestResources.nextElement().openStream();
                Throwable throwable = null;
                try {
                    Manifest manifest = new Manifest(inputStream);
                    String startClass = manifest.getMainAttributes().getValue("Start-Class");
                    if (startClass == null) continue;
                    Class clazz = ClassUtils.forName((String)startClass, (ClassLoader)this.getClass().getClassLoader());
                    return clazz;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private File findSource(Class<?> sourceClass) {
        try {
            File source;
            ProtectionDomain domain = sourceClass != null ? sourceClass.getProtectionDomain() : null;
            CodeSource codeSource = domain != null ? domain.getCodeSource() : null;
            URL location = codeSource != null ? codeSource.getLocation() : null;
            File file = source = location != null ? this.findSource(location) : null;
            if (source != null && source.exists() && !this.isUnitTest()) {
                return source.getAbsoluteFile();
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private boolean isUnitTest() {
        try {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            for (int i = stackTrace.length - 1; i >= 0; --i) {
                if (!stackTrace[i].getClassName().startsWith("org.junit.")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private File findSource(URL location) throws IOException {
        URLConnection connection = location.openConnection();
        if (connection instanceof JarURLConnection) {
            return this.getRootJarFile(((JarURLConnection)connection).getJarFile());
        }
        return new File(location.getPath());
    }

    private File getRootJarFile(JarFile jarFile) {
        String name = jarFile.getName();
        int separator = name.indexOf("!/");
        if (separator > 0) {
            name = name.substring(0, separator);
        }
        return new File(name);
    }

    private File findHomeDir(File source) {
        File homeDir = source;
        File file = homeDir = homeDir != null ? homeDir : this.findDefaultHomeDir();
        if (homeDir.isFile()) {
            homeDir = homeDir.getParentFile();
        }
        homeDir = homeDir.exists() ? homeDir : new File(".");
        return homeDir.getAbsoluteFile();
    }

    private File findDefaultHomeDir() {
        String userDir = System.getProperty("user.dir");
        return new File(StringUtils.hasLength((String)userDir) ? userDir : ".");
    }

    public File getSource() {
        return this.source;
    }

    public File getDir() {
        return this.dir;
    }

    public String toString() {
        return this.getDir().toString();
    }
}

