/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.autoconfigure.actuate.endpoint.web;

import java.util.Collection;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.webmvc.actuate.endpoint.web.AdditionalHealthEndpointPathsWebMvcHandlerMapping;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={HealthEndpoint.class})
@ConditionalOnBean(value={HealthEndpoint.class, WebEndpointsSupplier.class, HealthEndpointGroups.class})
@ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB})
public final class WebMvcHealthEndpointExtensionAutoConfiguration {
    @Bean
    AdditionalHealthEndpointPathsWebMvcHandlerMapping healthEndpointWebMvcHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups groups) {
        ExposableWebEndpoint health = WebMvcHealthEndpointExtensionAutoConfiguration.getHealthEndpoint(webEndpointsSupplier);
        return new AdditionalHealthEndpointPathsWebMvcHandlerMapping(health, groups.getAllWithAdditionalPath(WebServerNamespace.SERVER));
    }

    private static @Nullable ExposableWebEndpoint getHealthEndpoint(WebEndpointsSupplier webEndpointsSupplier) {
        Collection webEndpoints = webEndpointsSupplier.getEndpoints();
        return webEndpoints.stream().filter(endpoint -> endpoint.getEndpointId().equals((Object)HealthEndpoint.ID)).findFirst().orElse(null);
    }
}

