/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webmvc.test.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.webmvc.autoconfigure.DispatcherServletPath;
import org.springframework.boot.webmvc.autoconfigure.WebMvcAutoConfiguration;
import org.springframework.boot.webmvc.autoconfigure.WebMvcProperties;
import org.springframework.boot.webmvc.test.autoconfigure.MockMvcConfiguration;
import org.springframework.boot.webmvc.test.autoconfigure.MockMvcTesterConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.web.servlet.DispatcherServlet;

@AutoConfiguration(after={WebMvcAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={ServerProperties.class, WebMvcProperties.class})
@Import(value={MockMvcConfiguration.class, MockMvcTesterConfiguration.class})
public final class MockMvcAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    DispatcherServletPath dispatcherServletPath(WebMvcProperties webMvcProperties) {
        return () -> webMvcProperties.getServlet().getPath();
    }

    @Bean
    @ConditionalOnMissingBean
    DispatcherServlet dispatcherServlet(MockMvc mockMvc) {
        return mockMvc.getDispatcherServlet();
    }
}

