/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webflux.actuate.endpoint.web;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.EndpointMediaTypes;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebOperation;
import org.springframework.boot.actuate.endpoint.web.WebOperationRequestPredicate;
import org.springframework.boot.health.actuate.endpoint.AdditionalHealthEndpointPath;
import org.springframework.boot.health.actuate.endpoint.HealthEndpointGroup;
import org.springframework.boot.webflux.actuate.endpoint.web.AbstractWebFluxEndpointHandlerMapping;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.reactive.result.method.RequestMappingInfo;
import reactor.core.publisher.Mono;

public class AdditionalHealthEndpointPathsWebFluxHandlerMapping
extends AbstractWebFluxEndpointHandlerMapping {
    private final EndpointMapping endpointMapping;
    private final @Nullable ExposableWebEndpoint healthEndpoint;
    private final Set<HealthEndpointGroup> groups;

    public AdditionalHealthEndpointPathsWebFluxHandlerMapping(EndpointMapping endpointMapping, @Nullable ExposableWebEndpoint healthEndpoint, Set<HealthEndpointGroup> groups) {
        super(endpointMapping, AdditionalHealthEndpointPathsWebFluxHandlerMapping.asList(healthEndpoint), new EndpointMediaTypes(new String[0]), null, false);
        this.endpointMapping = endpointMapping;
        this.groups = groups;
        this.healthEndpoint = healthEndpoint;
    }

    private static Collection<ExposableWebEndpoint> asList(@Nullable ExposableWebEndpoint healthEndpoint) {
        return healthEndpoint != null ? Collections.singletonList(healthEndpoint) : Collections.emptyList();
    }

    @Override
    protected void initHandlerMethods() {
        if (this.healthEndpoint == null) {
            return;
        }
        for (WebOperation operation : this.healthEndpoint.getOperations()) {
            WebOperationRequestPredicate predicate = operation.getRequestPredicate();
            String matchAllRemainingPathSegmentsVariable = predicate.getMatchAllRemainingPathSegmentsVariable();
            if (matchAllRemainingPathSegmentsVariable == null) continue;
            for (HealthEndpointGroup group : this.groups) {
                AdditionalHealthEndpointPath additionalPath = group.getAdditionalPath();
                if (additionalPath == null) continue;
                RequestMappingInfo requestMappingInfo = this.getRequestMappingInfo(operation, additionalPath.getValue());
                this.registerReadMapping(requestMappingInfo, this.healthEndpoint, operation);
            }
        }
    }

    private RequestMappingInfo getRequestMappingInfo(WebOperation operation, String additionalPath) {
        WebOperationRequestPredicate predicate = operation.getRequestPredicate();
        String path = this.endpointMapping.createSubPath(additionalPath);
        RequestMethod method = RequestMethod.valueOf((String)predicate.getHttpMethod().name());
        String[] consumes = StringUtils.toStringArray((Collection)predicate.getConsumes());
        String[] produces = StringUtils.toStringArray((Collection)predicate.getProduces());
        return RequestMappingInfo.paths((String[])new String[]{path}).methods(new RequestMethod[]{method}).consumes(consumes).produces(produces).build();
    }

    @Override
    protected AbstractWebFluxEndpointHandlerMapping.LinksHandler getLinksHandler() {
        return exchange -> Mono.empty();
    }
}

