/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webclient.autoconfigure.service;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.autoconfigure.reactive.AbstractClientHttpConnectorProperties;
import org.springframework.boot.http.client.autoconfigure.reactive.ClientHttpConnectors;
import org.springframework.boot.http.client.autoconfigure.reactive.HttpReactiveClientProperties;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorBuilder;
import org.springframework.boot.http.client.reactive.ClientHttpConnectorSettings;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.boot.webclient.autoconfigure.service.ReactiveHttpClientServiceProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.support.WebClientHttpServiceGroupConfigurer;
import org.springframework.web.service.registry.HttpServiceGroup;
import org.springframework.web.service.registry.HttpServiceGroupConfigurer;

class WebClientPropertiesHttpServiceGroupConfigurer
implements WebClientHttpServiceGroupConfigurer {
    private final ClassLoader classLoader;
    private final ObjectProvider<SslBundles> sslBundles;
    private final HttpReactiveClientProperties clientProperties;
    private final ReactiveHttpClientServiceProperties serviceProperties;
    private final ObjectProvider<ClientHttpConnectorBuilder<?>> clientConnectorBuilder;
    private final ObjectProvider<ClientHttpConnectorSettings> clientConnectorSettings;

    WebClientPropertiesHttpServiceGroupConfigurer(ClassLoader classLoader, ObjectProvider<SslBundles> sslBundles, HttpReactiveClientProperties clientProperties, ReactiveHttpClientServiceProperties serviceProperties, ObjectProvider<ClientHttpConnectorBuilder<?>> clientConnectorBuilder, ObjectProvider<ClientHttpConnectorSettings> clientConnectorSettings) {
        this.classLoader = classLoader;
        this.sslBundles = sslBundles;
        this.clientProperties = clientProperties;
        this.serviceProperties = serviceProperties;
        this.clientConnectorBuilder = clientConnectorBuilder;
        this.clientConnectorSettings = clientConnectorSettings;
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void configureGroups(HttpServiceGroupConfigurer.Groups<WebClient.Builder> groups) {
        groups.forEachClient(this::configureClient);
    }

    private void configureClient(HttpServiceGroup group, WebClient.Builder builder) {
        ReactiveHttpClientServiceProperties.Group groupProperties = this.serviceProperties.getGroup().get(group.name());
        builder.clientConnector(this.getClientConnector(groupProperties));
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(this.serviceProperties::getBaseUrl).whenHasText().to(arg_0 -> ((WebClient.Builder)builder).baseUrl(arg_0));
        map.from(this.serviceProperties::getDefaultHeader).as(this::putAllHeaders).to(arg_0 -> ((WebClient.Builder)builder).defaultHeaders(arg_0));
        if (groupProperties != null) {
            map.from(groupProperties::getBaseUrl).whenHasText().to(arg_0 -> ((WebClient.Builder)builder).baseUrl(arg_0));
            map.from(groupProperties::getDefaultHeader).as(this::putAllHeaders).to(arg_0 -> ((WebClient.Builder)builder).defaultHeaders(arg_0));
        }
    }

    private Consumer<HttpHeaders> putAllHeaders(Map<String, List<String>> defaultHeaders) {
        return httpHeaders -> httpHeaders.putAll(defaultHeaders);
    }

    private ClientHttpConnector getClientConnector(ReactiveHttpClientServiceProperties.Group groupProperties) {
        ClientHttpConnectors connectors = new ClientHttpConnectors(this.sslBundles, new AbstractClientHttpConnectorProperties[]{groupProperties, this.serviceProperties, this.clientProperties});
        ClientHttpConnectorBuilder builder = (ClientHttpConnectorBuilder)this.clientConnectorBuilder.getIfAvailable(() -> connectors.builder(this.classLoader));
        ClientHttpConnectorSettings settings = (ClientHttpConnectorSettings)this.clientConnectorSettings.getIfAvailable(() -> ((ClientHttpConnectors)connectors).settings());
        return builder.build(settings);
    }
}

