/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webclient.test.autoconfigure;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.jackson.JacksonComponent;
import org.springframework.boot.test.context.filter.annotation.StandardAnnotationCustomizableTypeExcludeFilter;
import org.springframework.boot.webclient.test.autoconfigure.WebClientTest;
import org.springframework.util.ClassUtils;

class WebClientTypeExcludeFilter
extends StandardAnnotationCustomizableTypeExcludeFilter<WebClientTest> {
    private static final Class<?>[] NO_COMPONENTS = new Class[0];
    private static final String DATABIND_MODULE_CLASS_NAME = "tools.jackson.databind.JacksonModule";
    private static final Set<Class<?>> KNOWN_INCLUDES;
    private final Class<?>[] components = this.getAnnotation().getValue("components", Class[].class).orElse(NO_COMPONENTS);

    WebClientTypeExcludeFilter(Class<?> testClass) {
        super(testClass);
    }

    protected Set<Class<?>> getKnownIncludes() {
        return KNOWN_INCLUDES;
    }

    protected Set<Class<?>> getComponentIncludes() {
        return new LinkedHashSet(Arrays.asList(this.components));
    }

    static {
        LinkedHashSet includes = new LinkedHashSet();
        if (ClassUtils.isPresent((String)DATABIND_MODULE_CLASS_NAME, (ClassLoader)WebClientTypeExcludeFilter.class.getClassLoader())) {
            try {
                includes.add(Class.forName(DATABIND_MODULE_CLASS_NAME, true, WebClientTypeExcludeFilter.class.getClassLoader()));
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Failed to load tools.jackson.databind.JacksonModule", ex);
            }
            includes.add(JacksonComponent.class);
        }
        KNOWN_INCLUDES = Collections.unmodifiableSet(includes);
    }
}

