/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server.servlet;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.web.server.ConfigurableWebServerFactory;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.servlet.ContextPath;
import org.springframework.boot.web.server.servlet.CookieSameSiteSupplier;
import org.springframework.boot.web.server.servlet.Jsp;
import org.springframework.boot.web.server.servlet.ServletWebServerFactory;
import org.springframework.boot.web.server.servlet.ServletWebServerSettings;
import org.springframework.boot.web.server.servlet.Session;
import org.springframework.boot.web.server.servlet.WebListenerRegistry;
import org.springframework.boot.web.servlet.ServletContextInitializer;

public interface ConfigurableServletWebServerFactory
extends ConfigurableWebServerFactory,
ServletWebServerFactory,
WebListenerRegistry {
    public ServletWebServerSettings getSettings();

    default public void setContextPath(String contextPath) {
        this.getSettings().setContextPath(ContextPath.of(contextPath));
    }

    default public String getContextPath() {
        return this.getSettings().getContextPath().toString();
    }

    default public void setDisplayName(String displayName) {
        this.getSettings().setDisplayName(displayName);
    }

    default public void setSession(Session session) {
        this.getSettings().setSession(session);
    }

    default public void setRegisterDefaultServlet(boolean registerDefaultServlet) {
        this.getSettings().setRegisterDefaultServlet(registerDefaultServlet);
    }

    default public void setMimeMappings(MimeMappings mimeMappings) {
        this.getSettings().setMimeMappings(mimeMappings);
    }

    default public void addMimeMappings(MimeMappings mimeMappings) {
        this.getSettings().addMimeMappings(mimeMappings);
    }

    default public void setDocumentRoot(@Nullable File documentRoot) {
        this.getSettings().setDocumentRoot(documentRoot);
    }

    default public void setInitializers(List<? extends ServletContextInitializer> initializers) {
        this.getSettings().setInitializers(initializers);
    }

    default public void addInitializers(ServletContextInitializer ... initializers) {
        this.getSettings().addInitializers(initializers);
    }

    default public void setJsp(Jsp jsp) {
        this.getSettings().setJsp(jsp);
    }

    default public void setLocaleCharsetMappings(Map<Locale, Charset> localeCharsetMappings) {
        this.getSettings().setLocaleCharsetMappings(localeCharsetMappings);
    }

    default public void setInitParameters(Map<String, String> initParameters) {
        this.getSettings().setInitParameters(initParameters);
    }

    default public void setCookieSameSiteSuppliers(List<? extends CookieSameSiteSupplier> cookieSameSiteSuppliers) {
        this.getSettings().setCookieSameSiteSuppliers(cookieSameSiteSuppliers);
    }

    default public void addCookieSameSiteSuppliers(CookieSameSiteSupplier ... cookieSameSiteSuppliers) {
        this.getSettings().addCookieSameSiteSuppliers(cookieSameSiteSuppliers);
    }

    @Override
    default public void addWebListeners(String ... webListenerClassNames) {
        this.getSettings().addWebListenerClassNames(webListenerClassNames);
    }
}

