/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.server;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationPropertiesSource;
import org.springframework.lang.Contract;

@ConfigurationPropertiesSource
public class Ssl {
    private boolean enabled = true;
    private @Nullable String bundle;
    private @Nullable ClientAuth clientAuth;
    private String @Nullable [] ciphers;
    private String @Nullable [] enabledProtocols;
    private @Nullable String keyAlias;
    private @Nullable String keyPassword;
    private @Nullable String keyStore;
    private @Nullable String keyStorePassword;
    private @Nullable String keyStoreType;
    private @Nullable String keyStoreProvider;
    private @Nullable String trustStore;
    private @Nullable String trustStorePassword;
    private @Nullable String trustStoreType;
    private @Nullable String trustStoreProvider;
    private @Nullable String certificate;
    private @Nullable String certificatePrivateKey;
    private @Nullable String trustCertificate;
    private @Nullable String trustCertificatePrivateKey;
    private String protocol = "TLS";
    private List<ServerNameSslBundle> serverNameBundles = new ArrayList<ServerNameSslBundle>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public @Nullable String getBundle() {
        return this.bundle;
    }

    public void setBundle(@Nullable String bundle) {
        this.bundle = bundle;
    }

    public @Nullable ClientAuth getClientAuth() {
        return this.clientAuth;
    }

    public void setClientAuth(@Nullable ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
    }

    public String @Nullable [] getCiphers() {
        return this.ciphers;
    }

    public void setCiphers(String @Nullable [] ciphers) {
        this.ciphers = ciphers;
    }

    public String @Nullable [] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public void setEnabledProtocols(String @Nullable [] enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public @Nullable String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyAlias(@Nullable String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public @Nullable String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(@Nullable String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public @Nullable String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(@Nullable String keyStore) {
        this.keyStore = keyStore;
    }

    public @Nullable String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(@Nullable String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public @Nullable String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(@Nullable String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public @Nullable String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(@Nullable String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public @Nullable String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(@Nullable String trustStore) {
        this.trustStore = trustStore;
    }

    public @Nullable String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public void setTrustStorePassword(@Nullable String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public @Nullable String getTrustStoreType() {
        return this.trustStoreType;
    }

    public void setTrustStoreType(@Nullable String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public @Nullable String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    public void setTrustStoreProvider(@Nullable String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    public @Nullable String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(@Nullable String certificate) {
        this.certificate = certificate;
    }

    public @Nullable String getCertificatePrivateKey() {
        return this.certificatePrivateKey;
    }

    public void setCertificatePrivateKey(@Nullable String certificatePrivateKey) {
        this.certificatePrivateKey = certificatePrivateKey;
    }

    public @Nullable String getTrustCertificate() {
        return this.trustCertificate;
    }

    public void setTrustCertificate(@Nullable String trustCertificate) {
        this.trustCertificate = trustCertificate;
    }

    public @Nullable String getTrustCertificatePrivateKey() {
        return this.trustCertificatePrivateKey;
    }

    public void setTrustCertificatePrivateKey(@Nullable String trustCertificatePrivateKey) {
        this.trustCertificatePrivateKey = trustCertificatePrivateKey;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Contract(value="null -> false")
    public static boolean isEnabled(@Nullable Ssl ssl) {
        return ssl != null && ssl.isEnabled();
    }

    public List<ServerNameSslBundle> getServerNameBundles() {
        return this.serverNameBundles;
    }

    public void setServerNameBundles(List<ServerNameSslBundle> serverNameBundles) {
        this.serverNameBundles = serverNameBundles;
    }

    public static Ssl forBundle(String bundle) {
        Ssl ssl = new Ssl();
        ssl.setBundle(bundle);
        return ssl;
    }

    public static enum ClientAuth {
        NONE,
        WANT,
        NEED;


        @Contract(value="_, !null, _, _ -> !null")
        public static <R> @Nullable R map(@Nullable ClientAuth clientAuth, @Nullable R none, R want, R need) {
            if (clientAuth == null) {
                return none;
            }
            return switch (clientAuth.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> none;
                case 1 -> want;
                case 2 -> need;
            };
        }
    }

    public record ServerNameSslBundle(String serverName, String bundle) {
    }
}

