/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.undertow;

import io.undertow.Undertow;
import io.undertow.protocols.ssl.SNIContextMatcher;
import io.undertow.protocols.ssl.SNISSLContext;
import java.net.InetAddress;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslOptions;
import org.springframework.boot.undertow.UndertowBuilderCustomizer;
import org.springframework.boot.web.server.Ssl;
import org.xnio.Options;
import org.xnio.Sequence;
import org.xnio.SslClientAuthMode;

class SslBuilderCustomizer
implements UndertowBuilderCustomizer {
    private final int port;
    private final InetAddress address;
    private final Ssl.ClientAuth clientAuth;
    private final SslBundle sslBundle;
    private final Map<String, SslBundle> serverNameSslBundles;

    SslBuilderCustomizer(int port, InetAddress address, Ssl.ClientAuth clientAuth, SslBundle sslBundle, Map<String, SslBundle> serverNameSslBundles) {
        this.port = port;
        this.address = address;
        this.clientAuth = clientAuth;
        this.sslBundle = sslBundle;
        this.serverNameSslBundles = serverNameSslBundles;
    }

    @Override
    public void customize(Undertow.Builder builder) {
        SslOptions options = this.sslBundle.getOptions();
        builder.addHttpsListener(this.port, this.getListenAddress(), this.createSslContext());
        builder.setSocketOption(Options.SSL_CLIENT_AUTH_MODE, (Object)((SslClientAuthMode)Ssl.ClientAuth.map((Ssl.ClientAuth)this.clientAuth, (Object)SslClientAuthMode.NOT_REQUESTED, (Object)SslClientAuthMode.REQUESTED, (Object)SslClientAuthMode.REQUIRED)));
        if (options.getEnabledProtocols() != null) {
            builder.setSocketOption(Options.SSL_ENABLED_PROTOCOLS, (Object)Sequence.of((Object[])options.getEnabledProtocols()));
        }
        if (options.getCiphers() != null) {
            builder.setSocketOption(Options.SSL_ENABLED_CIPHER_SUITES, (Object)Sequence.of((Object[])options.getCiphers()));
        }
    }

    private SSLContext createSslContext() {
        SNIContextMatcher.Builder builder = new SNIContextMatcher.Builder();
        builder.setDefaultContext(this.sslBundle.createSslContext());
        this.serverNameSslBundles.forEach((serverName, sslBundle) -> builder.addMatch(serverName, sslBundle.createSslContext()));
        return new SNISSLContext(builder.build());
    }

    private String getListenAddress() {
        if (this.address == null) {
            return "0.0.0.0";
        }
        return this.address.getHostAddress();
    }
}

