/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.transaction.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.transaction.autoconfigure.ExecutionListenersTransactionManagerCustomizer;
import org.springframework.boot.transaction.autoconfigure.TransactionAutoConfiguration;
import org.springframework.boot.transaction.autoconfigure.TransactionManagerCustomizer;
import org.springframework.boot.transaction.autoconfigure.TransactionManagerCustomizers;
import org.springframework.boot.transaction.autoconfigure.TransactionProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionExecutionListener;

@ConditionalOnClass(value={PlatformTransactionManager.class})
@AutoConfiguration(before={TransactionAutoConfiguration.class})
@EnableConfigurationProperties(value={TransactionProperties.class})
public class TransactionManagerCustomizationAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    TransactionManagerCustomizers platformTransactionManagerCustomizers(ObjectProvider<TransactionManagerCustomizer<?>> customizers) {
        return TransactionManagerCustomizers.of(customizers.orderedStream().toList());
    }

    @Bean
    ExecutionListenersTransactionManagerCustomizer transactionExecutionListeners(ObjectProvider<TransactionExecutionListener> listeners) {
        return new ExecutionListenersTransactionManagerCustomizer(listeners.orderedStream().toList());
    }
}

