/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tracing.autoconfigure;

import io.micrometer.core.instrument.observation.MeterObservationHandler;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Tracer;
import io.micrometer.tracing.handler.TracingAwareMeterObservationHandler;
import io.micrometer.tracing.handler.TracingObservationHandler;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.observation.autoconfigure.ObservationHandlerGroup;

class TracingAndMeterObservationHandlerGroup
implements ObservationHandlerGroup {
    private final Tracer tracer;

    TracingAndMeterObservationHandlerGroup(Tracer tracer) {
        this.tracer = tracer;
    }

    public boolean isMember(ObservationHandler<?> handler) {
        return MeterObservationHandler.class.isInstance(handler) || TracingObservationHandler.class.isInstance(handler);
    }

    public int compareTo(ObservationHandlerGroup other) {
        if (other instanceof TracingAndMeterObservationHandlerGroup) {
            return 0;
        }
        return MeterObservationHandler.class.isAssignableFrom(other.handlerType()) ? -1 : 1;
    }

    public void registerMembers(ObservationRegistry.ObservationConfig config, List<ObservationHandler<?>> members) {
        ArrayList tracingHandlers = new ArrayList(members.size());
        ArrayList metricsHandlers = new ArrayList(members.size());
        for (ObservationHandler<?> member : members) {
            if (member instanceof MeterObservationHandler) {
                MeterObservationHandler meterObservationHandler = (MeterObservationHandler)member;
                if (!(member instanceof TracingAwareMeterObservationHandler)) {
                    metricsHandlers.add((ObservationHandler<?>)new TracingAwareMeterObservationHandler(meterObservationHandler, this.tracer));
                    continue;
                }
            }
            tracingHandlers.add(member);
        }
        this.registerHandlers(config, tracingHandlers);
        this.registerHandlers(config, metricsHandlers);
    }

    private void registerHandlers(ObservationRegistry.ObservationConfig config, List<ObservationHandler<?>> handlers) {
        if (handlers.size() == 1) {
            config.observationHandler(handlers.get(0));
        } else if (!handlers.isEmpty()) {
            config.observationHandler((ObservationHandler)new ObservationHandler.FirstMatchingCompositeObservationHandler(handlers));
        }
    }

    public Class<?> handlerType() {
        return TracingObservationHandler.class;
    }
}

