/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat.autoconfigure.servlet;

import jakarta.servlet.ServletRequest;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.UpgradeProtocol;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.tomcat.TomcatConnectorCustomizer;
import org.springframework.boot.tomcat.TomcatContextCustomizer;
import org.springframework.boot.tomcat.TomcatProtocolHandlerCustomizer;
import org.springframework.boot.tomcat.autoconfigure.TomcatServerProperties;
import org.springframework.boot.tomcat.autoconfigure.TomcatWebServerConfiguration;
import org.springframework.boot.tomcat.autoconfigure.servlet.TomcatServletWebServerFactoryCustomizer;
import org.springframework.boot.tomcat.servlet.TomcatServletWebServerFactory;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.boot.web.server.autoconfigure.servlet.ForwardedHeaderFilterCustomizer;
import org.springframework.boot.web.server.autoconfigure.servlet.ServletWebServerConfiguration;
import org.springframework.boot.web.server.servlet.ServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@AutoConfiguration
@ConditionalOnClass(value={ServletRequest.class, Tomcat.class, UpgradeProtocol.class, TomcatServletWebServerFactory.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@EnableConfigurationProperties(value={TomcatServerProperties.class})
@Import(value={ServletWebServerConfiguration.class, TomcatWebServerConfiguration.class})
public class TomcatServletWebServerAutoConfiguration {
    private final TomcatServerProperties tomcatProperties;

    public TomcatServletWebServerAutoConfiguration(TomcatServerProperties tomcatProperties) {
        this.tomcatProperties = tomcatProperties;
    }

    @Bean
    @ConditionalOnMissingBean(value={ServletWebServerFactory.class}, search=SearchStrategy.CURRENT)
    TomcatServletWebServerFactory tomcatServletWebServerFactory(ObjectProvider<TomcatConnectorCustomizer> connectorCustomizers, ObjectProvider<TomcatContextCustomizer> contextCustomizers, ObjectProvider<TomcatProtocolHandlerCustomizer<?>> protocolHandlerCustomizers) {
        TomcatServletWebServerFactory factory = new TomcatServletWebServerFactory();
        factory.getConnectorCustomizers().addAll(connectorCustomizers.orderedStream().toList());
        factory.getContextCustomizers().addAll(contextCustomizers.orderedStream().toList());
        factory.getProtocolHandlerCustomizers().addAll(protocolHandlerCustomizers.orderedStream().toList());
        return factory;
    }

    @Bean
    TomcatServletWebServerFactoryCustomizer tomcatServletWebServerFactoryCustomizer(TomcatServerProperties tomcatProperties) {
        return new TomcatServletWebServerFactoryCustomizer(tomcatProperties);
    }

    @Bean
    @ConditionalOnProperty(name={"server.forward-headers-strategy"}, havingValue="framework")
    ForwardedHeaderFilterCustomizer tomcatForwardedHeaderFilterCustomizer(ServerProperties serverProperties) {
        return filter -> filter.setRelativeRedirects(this.tomcatProperties.isUseRelativeRedirects());
    }
}

