/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection;

import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.boot.testcontainers.service.connection.ServiceConnection;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.log.LogMessage;
import org.springframework.util.StringUtils;
import org.testcontainers.containers.Container;
import org.testcontainers.utility.DockerImageName;

public final class ContainerConnectionSource<C extends Container<?>>
implements OriginProvider {
    private static final Log logger = LogFactory.getLog(ContainerConnectionSource.class);
    private final String beanNameSuffix;
    private final Origin origin;
    private final Class<C> containerType;
    private final String containerImageName;
    private final String connectionName;
    private final Set<Class<?>> connectionDetailsTypes;
    private final Supplier<C> containerSupplier;

    ContainerConnectionSource(String beanNameSuffix, Origin origin, Class<C> containerType, String containerImageName, MergedAnnotation<ServiceConnection> annotation, Supplier<C> containerSupplier) {
        this.beanNameSuffix = beanNameSuffix;
        this.origin = origin;
        this.containerType = containerType;
        this.containerImageName = containerImageName;
        this.connectionName = ContainerConnectionSource.getOrDeduceConnectionName(annotation.getString("name"), containerImageName);
        this.connectionDetailsTypes = Set.of(annotation.getClassArray("type"));
        this.containerSupplier = containerSupplier;
    }

    ContainerConnectionSource(String beanNameSuffix, Origin origin, Class<C> containerType, String containerImageName, ServiceConnection annotation, Supplier<C> containerSupplier) {
        this.beanNameSuffix = beanNameSuffix;
        this.origin = origin;
        this.containerType = containerType;
        this.containerImageName = containerImageName;
        this.connectionName = ContainerConnectionSource.getOrDeduceConnectionName(annotation.name(), containerImageName);
        this.connectionDetailsTypes = Set.of(annotation.type());
        this.containerSupplier = containerSupplier;
    }

    private static String getOrDeduceConnectionName(String connectionName, String containerImageName) {
        if (StringUtils.hasText((String)connectionName)) {
            return connectionName;
        }
        if (StringUtils.hasText((String)containerImageName)) {
            DockerImageName imageName = DockerImageName.parse((String)containerImageName);
            imageName.assertValid();
            return imageName.getRepository();
        }
        return null;
    }

    public boolean accepts(String requiredConnectionName, Class<?> requiredContainerType, Class<?> requiredConnectionDetailsType) {
        if (StringUtils.hasText((String)requiredConnectionName) && !requiredConnectionName.equalsIgnoreCase(this.connectionName)) {
            logger.trace((Object)LogMessage.of(() -> "%s not accepted as source connection name '%s' does not match required connection name '%s'".formatted(this, this.connectionName, requiredConnectionName)));
            return false;
        }
        if (!requiredContainerType.isAssignableFrom(this.containerType)) {
            logger.trace((Object)LogMessage.of(() -> "%s not accepted as source container type %s is not assignable from %s".formatted(this, this.containerType.getName(), requiredContainerType.getName())));
            return false;
        }
        if (!this.connectionDetailsTypes.isEmpty() && this.connectionDetailsTypes.stream().noneMatch(candidate -> candidate.isAssignableFrom(requiredConnectionDetailsType))) {
            logger.trace((Object)LogMessage.of(() -> "%s not accepted as source connection details types %s has no element assignable from %s".formatted(this, this.connectionDetailsTypes.stream().map(Class::getName).toList(), requiredConnectionDetailsType.getName())));
            return false;
        }
        logger.trace((Object)LogMessage.of(() -> "%s accepted for connection name '%s' container type %s, connection details type %s".formatted(this, requiredConnectionName, requiredContainerType.getName(), requiredConnectionDetailsType.getName())));
        return true;
    }

    String getBeanNameSuffix() {
        return this.beanNameSuffix;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    String getContainerImageName() {
        return this.containerImageName;
    }

    String getConnectionName() {
        return this.connectionName;
    }

    Supplier<C> getContainerSupplier() {
        return this.containerSupplier;
    }

    Set<Class<?>> getConnectionDetailsTypes() {
        return this.connectionDetailsTypes;
    }

    public String toString() {
        return "@ServiceConnection source for %s".formatted(this.origin);
    }
}

