/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.service.connection.ConnectionDetailsFactories;
import org.springframework.boot.testcontainers.lifecycle.TestcontainersLifecycleApplicationContextInitializer;
import org.springframework.boot.testcontainers.service.connection.ConnectionDetailsRegistrar;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.testcontainers.containers.Container;

class ServiceConnectionContextCustomizer
implements ContextCustomizer {
    private final List<ContainerConnectionSource<?>> sources;
    private final Set<CacheKey> keys;
    private final ConnectionDetailsFactories connectionDetailsFactories;

    ServiceConnectionContextCustomizer(List<ContainerConnectionSource<?>> sources) {
        this(sources, new ConnectionDetailsFactories());
    }

    ServiceConnectionContextCustomizer(List<ContainerConnectionSource<?>> sources, ConnectionDetailsFactories connectionDetailsFactories) {
        this.sources = sources;
        this.keys = sources.stream().map(CacheKey::new).collect(Collectors.toUnmodifiableSet());
        this.connectionDetailsFactories = connectionDetailsFactories;
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        new TestcontainersLifecycleApplicationContextInitializer().initialize(context);
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
            new ConnectionDetailsRegistrar((ListableBeanFactory)beanFactory, this.connectionDetailsFactories).registerBeanDefinitions(registry, this.sources);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.keys.equals(((ServiceConnectionContextCustomizer)obj).keys);
    }

    public int hashCode() {
        return this.keys.hashCode();
    }

    List<ContainerConnectionSource<?>> getSources() {
        return this.sources;
    }

    private record CacheKey(String connectionName, Set<Class<?>> connectionDetailsTypes, Container<?> container) {
        CacheKey(ContainerConnectionSource<?> source) {
            this(source.getConnectionName(), source.getConnectionDetailsTypes(), (Container)source.getContainerSupplier().get());
        }
    }
}

