/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.test.context.PropertyMapping;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotationPredicates;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class AnnotationsPropertySource
extends EnumerablePropertySource<Class<?>> {
    private static final Pattern CAMEL_CASE_PATTERN = Pattern.compile("([^A-Z-])([A-Z])");
    private final Map<String, Object> properties;

    AnnotationsPropertySource(Class<?> source) {
        this("Annotations", source);
    }

    AnnotationsPropertySource(String name, Class<?> source) {
        super(name, source);
        this.properties = this.getProperties(source);
    }

    private Map<String, Object> getProperties(Class<?> source) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        this.getProperties(source, properties);
        return properties;
    }

    private void getProperties(Class<?> source, Map<String, Object> properties) {
        MergedAnnotations.from(source, (MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.SUPERCLASS).stream().filter(MergedAnnotationPredicates.unique(MergedAnnotation::getType)).forEach(annotation -> {
            Class type = annotation.getType();
            MergedAnnotation typeMapping = MergedAnnotations.from((AnnotatedElement)type).get(PropertyMapping.class, MergedAnnotation::isDirectlyPresent);
            String prefix = typeMapping.getValue("value", String.class).orElse("");
            PropertyMapping.Skip defaultSkip = typeMapping.getValue("skip", PropertyMapping.Skip.class).orElse(PropertyMapping.Skip.YES);
            for (Method attribute : type.getDeclaredMethods()) {
                this.collectProperties(prefix, defaultSkip, (MergedAnnotation<?>)annotation, attribute, properties);
            }
        });
        if (TestContextAnnotationUtils.searchEnclosingClass(source)) {
            this.getProperties(source.getEnclosingClass(), properties);
        }
    }

    private void collectProperties(String prefix, PropertyMapping.Skip skip, MergedAnnotation<?> annotation, Method attribute, Map<String, Object> properties) {
        MergedAnnotation attributeMapping = MergedAnnotations.from((AnnotatedElement)attribute).get(PropertyMapping.class);
        skip = attributeMapping.getValue("skip", PropertyMapping.Skip.class).orElse(skip);
        if (skip == PropertyMapping.Skip.YES) {
            return;
        }
        Optional value = annotation.getValue(attribute.getName());
        if (value.isEmpty()) {
            return;
        }
        if (skip == PropertyMapping.Skip.ON_DEFAULT_VALUE && ObjectUtils.nullSafeEquals(value.get(), annotation.getDefaultValue(attribute.getName()).orElse(null))) {
            return;
        }
        String name = this.getName(prefix, attributeMapping, attribute);
        this.putProperties(name, skip, value.get(), properties);
    }

    private String getName(String prefix, MergedAnnotation<?> attributeMapping, Method attribute) {
        String name = attributeMapping.getValue("value", String.class).orElse("");
        if (!StringUtils.hasText((String)name)) {
            name = this.toKebabCase(attribute.getName());
        }
        return this.dotAppend(prefix, name);
    }

    private String toKebabCase(String name) {
        Matcher matcher = CAMEL_CASE_PATTERN.matcher(name);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(result, matcher.group(1) + "-" + StringUtils.uncapitalize((String)matcher.group(2)));
        }
        matcher.appendTail(result);
        return result.toString().toLowerCase(Locale.ENGLISH);
    }

    private String dotAppend(String prefix, String postfix) {
        if (StringUtils.hasText((String)prefix)) {
            return prefix.endsWith(".") ? prefix + postfix : prefix + "." + postfix;
        }
        return postfix;
    }

    private void putProperties(String name, PropertyMapping.Skip defaultSkip, Object value, Map<String, Object> properties) {
        if (ObjectUtils.isArray((Object)value)) {
            Object[] array = ObjectUtils.toObjectArray((Object)value);
            for (int i = 0; i < array.length; ++i) {
                this.putProperties(name + "[" + i + "]", defaultSkip, array[i], properties);
            }
        } else if (value instanceof MergedAnnotation) {
            MergedAnnotation annotation = (MergedAnnotation)value;
            for (Method attribute : annotation.getType().getDeclaredMethods()) {
                this.collectProperties(name, defaultSkip, (MergedAnnotation)value, attribute, properties);
            }
        } else {
            properties.put(name, value);
        }
    }

    public boolean containsProperty(String name) {
        return this.properties.containsKey(name);
    }

    public @Nullable Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String[] getPropertyNames() {
        return StringUtils.toStringArray(this.properties.keySet());
    }

    boolean isEmpty() {
        return this.properties.isEmpty();
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        return this.properties.equals(((AnnotationsPropertySource)((Object)obj)).properties);
    }

    public int hashCode() {
        return this.properties.hashCode();
    }
}

