/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.http.server;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.test.http.server.LazyUriBuilderFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.Assert;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;

public final class LocalTestWebServer {
    private final Scheme scheme;
    private final SingletonSupplier<BaseUriDetails> baseUriDetails;
    private final UriBuilderFactory uriBuilderFactory;

    private LocalTestWebServer(Scheme scheme, Supplier<BaseUriDetails> baseUriDetailsSupplier) {
        Assert.notNull((Object)((Object)scheme), (String)"'scheme' must not be null");
        Assert.notNull(baseUriDetailsSupplier, (String)"'baseUriDetailsSupplier' must not be null");
        this.scheme = scheme;
        this.baseUriDetails = SingletonSupplier.of(baseUriDetailsSupplier);
        this.uriBuilderFactory = new LazyUriBuilderFactory(() -> new DefaultUriBuilderFactory(((BaseUriDetails)this.baseUriDetails.obtain()).uri(this.scheme())));
    }

    public Scheme scheme() {
        return this.scheme;
    }

    public String uri() {
        return this.uri(null);
    }

    public String uri(@Nullable String uri) {
        return this.uriBuilder(uri).toUriString();
    }

    public UriBuilder uriBuilder(@Nullable String uri) {
        UriBuilderFactory factory = this.uriBuilderFactory();
        return uri != null ? factory.uriString(uri) : factory.builder();
    }

    public UriBuilderFactory uriBuilderFactory() {
        return this.uriBuilderFactory;
    }

    public LocalTestWebServer withPath(String path) {
        return LocalTestWebServer.of(this.scheme, () -> ((BaseUriDetails)this.baseUriDetails.obtain()).withPath(path));
    }

    public static LocalTestWebServer of(Scheme scheme, int port) {
        return LocalTestWebServer.of(scheme, port, null);
    }

    public static LocalTestWebServer of(Scheme scheme, int port, @Nullable String contextPath) {
        return LocalTestWebServer.of(scheme, () -> new BaseUriDetails(port, contextPath != null ? contextPath : ""));
    }

    public static LocalTestWebServer of(Scheme scheme, Supplier<BaseUriDetails> baseUriDetailsSupplier) {
        return new LocalTestWebServer(scheme, baseUriDetailsSupplier);
    }

    public static LocalTestWebServer obtain(ApplicationContext applicationContext) {
        LocalTestWebServer localTestWebServer = LocalTestWebServer.get(applicationContext);
        Assert.state((localTestWebServer != null ? 1 : 0) != 0, (String)"No local test web server available");
        return localTestWebServer;
    }

    public static @Nullable LocalTestWebServer get(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"'applicationContext' must not be null");
        SpringFactoriesLoader loader = SpringFactoriesLoader.forDefaultResourceLocation((ClassLoader)applicationContext.getClassLoader());
        return loader.load(Provider.class, SpringFactoriesLoader.ArgumentResolver.of(ApplicationContext.class, (Object)applicationContext)).stream().map(Provider::getLocalTestWebServer).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static enum Scheme {
        HTTP,
        HTTPS;

    }

    @FunctionalInterface
    public static interface Provider {
        public @Nullable LocalTestWebServer getLocalTestWebServer();
    }

    public record BaseUriDetails(int port, String path) {
        String uri(Scheme scheme) {
            return scheme.name().toLowerCase(Locale.ROOT) + "://localhost:" + this.port() + this.path();
        }

        BaseUriDetails withPath(String path) {
            return new BaseUriDetails(this.port(), this.path() + path);
        }
    }
}

