/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.runner;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.boot.context.annotation.Configurations;
import org.springframework.boot.context.annotation.UserConfigurations;
import org.springframework.boot.test.context.assertj.ApplicationContextAssertProvider;
import org.springframework.boot.test.context.runner.ContextConsumer;
import org.springframework.boot.test.util.TestPropertyValues;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigRegistry;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.Assert;

public abstract class AbstractApplicationContextRunner<SELF extends AbstractApplicationContextRunner<SELF, C, A>, C extends ConfigurableApplicationContext, A extends ApplicationContextAssertProvider<C>> {
    private final Supplier<C> contextFactory;
    private final List<ApplicationContextInitializer<? super C>> initializers;
    private final TestPropertyValues environmentProperties;
    private final TestPropertyValues systemProperties;
    private final ClassLoader classLoader;
    private final ApplicationContext parent;
    private final List<BeanRegistration<?>> beanRegistrations;
    private final List<Configurations> configurations;

    protected AbstractApplicationContextRunner(Supplier<C> contextFactory) {
        this(contextFactory, Collections.emptyList(), TestPropertyValues.empty(), TestPropertyValues.empty(), null, null, Collections.emptyList(), Collections.emptyList());
    }

    protected AbstractApplicationContextRunner(Supplier<C> contextFactory, List<ApplicationContextInitializer<? super C>> initializers, TestPropertyValues environmentProperties, TestPropertyValues systemProperties, ClassLoader classLoader, ApplicationContext parent, List<BeanRegistration<?>> beanRegistrations, List<Configurations> configurations) {
        Assert.notNull(contextFactory, (String)"ContextFactory must not be null");
        Assert.notNull((Object)environmentProperties, (String)"EnvironmentProperties must not be null");
        Assert.notNull((Object)systemProperties, (String)"SystemProperties must not be null");
        Assert.notNull(configurations, (String)"Configurations must not be null");
        Assert.notNull(initializers, (String)"Initializers must not be null");
        this.contextFactory = contextFactory;
        this.initializers = Collections.unmodifiableList(initializers);
        this.environmentProperties = environmentProperties;
        this.systemProperties = systemProperties;
        this.classLoader = classLoader;
        this.parent = parent;
        this.beanRegistrations = Collections.unmodifiableList(beanRegistrations);
        this.configurations = Collections.unmodifiableList(configurations);
    }

    public SELF withInitializer(ApplicationContextInitializer<? super C> initializer) {
        Assert.notNull(initializer, (String)"Initializer must not be null");
        return this.newInstance(this.contextFactory, this.add(this.initializers, initializer), this.environmentProperties, this.systemProperties, this.classLoader, this.parent, this.beanRegistrations, this.configurations);
    }

    public SELF withPropertyValues(String ... pairs) {
        return this.newInstance(this.contextFactory, this.initializers, this.environmentProperties.and(pairs), this.systemProperties, this.classLoader, this.parent, this.beanRegistrations, this.configurations);
    }

    public SELF withSystemProperties(String ... pairs) {
        return this.newInstance(this.contextFactory, this.initializers, this.environmentProperties, this.systemProperties.and(pairs), this.classLoader, this.parent, this.beanRegistrations, this.configurations);
    }

    public SELF withClassLoader(ClassLoader classLoader) {
        return this.newInstance(this.contextFactory, this.initializers, this.environmentProperties, this.systemProperties, classLoader, this.parent, this.beanRegistrations, this.configurations);
    }

    public SELF withParent(ApplicationContext parent) {
        return this.newInstance(this.contextFactory, this.initializers, this.environmentProperties, this.systemProperties, this.classLoader, parent, this.beanRegistrations, this.configurations);
    }

    public <T> SELF withBean(Class<T> type, Object ... constructorArgs) {
        return this.withBean(null, type, constructorArgs);
    }

    public <T> SELF withBean(String name, Class<T> type, Object ... constructorArgs) {
        return this.newInstance(this.contextFactory, this.initializers, this.environmentProperties, this.systemProperties, this.classLoader, this.parent, this.add(this.beanRegistrations, new BeanRegistration<T>(name, type, constructorArgs)), this.configurations);
    }

    public <T> SELF withBean(Class<T> type, Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
        return this.withBean(null, type, supplier, customizers);
    }

    public <T> SELF withBean(String name, Class<T> type, Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
        return this.newInstance(this.contextFactory, this.initializers, this.environmentProperties, this.systemProperties, this.classLoader, this.parent, this.add(this.beanRegistrations, new BeanRegistration<T>(name, type, supplier, customizers)), this.configurations);
    }

    public SELF withUserConfiguration(Class<?> ... configurationClasses) {
        return this.withConfiguration((Configurations)UserConfigurations.of((Class[])configurationClasses));
    }

    public SELF withConfiguration(Configurations configurations) {
        Assert.notNull((Object)configurations, (String)"Configurations must not be null");
        return this.newInstance(this.contextFactory, this.initializers, this.environmentProperties, this.systemProperties, this.classLoader, this.parent, this.beanRegistrations, this.add(this.configurations, configurations));
    }

    public SELF with(Function<SELF, SELF> customizer) {
        return (SELF)((AbstractApplicationContextRunner)customizer.apply(this));
    }

    private <T> List<T> add(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return result;
    }

    protected abstract SELF newInstance(Supplier<C> var1, List<ApplicationContextInitializer<? super C>> var2, TestPropertyValues var3, TestPropertyValues var4, ClassLoader var5, ApplicationContext var6, List<BeanRegistration<?>> var7, List<Configurations> var8);

    public SELF run(ContextConsumer<? super A> consumer) {
        this.withContextClassLoader(this.classLoader, () -> this.systemProperties.applyToSystemProperties(() -> {
            try (A context = this.createAssertableContext();){
                this.accept(consumer, context);
            }
            return null;
        }));
        return (SELF)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void withContextClassLoader(ClassLoader classLoader, Runnable action) {
        if (classLoader == null) {
            action.run();
        } else {
            Thread currentThread = Thread.currentThread();
            ClassLoader previous = currentThread.getContextClassLoader();
            currentThread.setContextClassLoader(classLoader);
            try {
                action.run();
            }
            finally {
                currentThread.setContextClassLoader(previous);
            }
        }
    }

    private A createAssertableContext() {
        ResolvableType resolvableType = ResolvableType.forClass(AbstractApplicationContextRunner.class, this.getClass());
        Class assertType = resolvableType.resolveGeneric(new int[]{1});
        Class contextType = resolvableType.resolveGeneric(new int[]{2});
        return (A)ApplicationContextAssertProvider.get(assertType, contextType, this::createAndLoadContext);
    }

    private C createAndLoadContext() {
        ConfigurableApplicationContext context = (ConfigurableApplicationContext)this.contextFactory.get();
        try {
            this.configureContext(context);
            return (C)context;
        }
        catch (RuntimeException ex) {
            context.close();
            throw ex;
        }
    }

    private void configureContext(C context) {
        if (this.parent != null) {
            context.setParent(this.parent);
        }
        if (this.classLoader != null) {
            Assert.isInstanceOf(DefaultResourceLoader.class, context);
            ((DefaultResourceLoader)context).setClassLoader(this.classLoader);
        }
        this.environmentProperties.applyTo((ConfigurableApplicationContext)context);
        Class[] classes = Configurations.getClasses(this.configurations);
        if (classes.length > 0) {
            ((AnnotationConfigRegistry)context).register(classes);
        }
        this.beanRegistrations.forEach(registration -> registration.apply((ConfigurableApplicationContext)context));
        this.initializers.forEach(initializer -> initializer.initialize(context));
        context.refresh();
    }

    private void accept(ContextConsumer<? super A> consumer, A context) {
        try {
            consumer.accept(context);
        }
        catch (Throwable ex) {
            this.rethrow(ex);
        }
    }

    private <E extends Throwable> void rethrow(Throwable e) throws E {
        throw e;
    }

    protected final class BeanRegistration<T> {
        Consumer<GenericApplicationContext> registrar;

        public BeanRegistration(String name, Class<T> type, Object ... constructorArgs) {
            this.registrar = context -> context.registerBean(name, type, constructorArgs);
        }

        public BeanRegistration(String name, Class<T> type, Supplier<T> supplier, BeanDefinitionCustomizer ... customizers) {
            this.registrar = context -> context.registerBean(name, type, supplier, customizers);
        }

        public void apply(ConfigurableApplicationContext context) {
            Assert.isInstanceOf(GenericApplicationContext.class, (Object)context);
            this.registrar.accept((GenericApplicationContext)context);
        }
    }
}

