/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfigurationAttributes;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.ContextCustomizerFactory;
import org.springframework.test.context.MergedContextConfiguration;

class DuplicateJsonObjectContextCustomizerFactory
implements ContextCustomizerFactory {
    DuplicateJsonObjectContextCustomizerFactory() {
    }

    public ContextCustomizer createContextCustomizer(Class<?> testClass, List<ContextConfigurationAttributes> configAttributes) {
        return new DuplicateJsonObjectContextCustomizer();
    }

    private static class DuplicateJsonObjectContextCustomizer
    implements ContextCustomizer {
        private final Log logger = LogFactory.getLog(DuplicateJsonObjectContextCustomizer.class);

        private DuplicateJsonObjectContextCustomizer() {
        }

        public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
            List<URL> jsonObjects = this.findJsonObjects();
            if (jsonObjects.size() > 1) {
                this.logDuplicateJsonObjectsWarning(jsonObjects);
            }
        }

        private List<URL> findJsonObjects() {
            ArrayList<URL> jsonObjects = new ArrayList<URL>();
            try {
                Enumeration<URL> resources = this.getClass().getClassLoader().getResources("org/json/JSONObject.class");
                while (resources.hasMoreElements()) {
                    jsonObjects.add(resources.nextElement());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return jsonObjects;
        }

        private void logDuplicateJsonObjectsWarning(List<URL> jsonObjects) {
            StringBuilder message = new StringBuilder("\n\nFound multiple occurrences of org.json.JSONObject on the class path:\n\n");
            for (URL jsonObject : jsonObjects) {
                message.append("\t" + jsonObject + "\n");
            }
            message.append("\nYou may wish to exclude one of them to ensure predictable runtime behaviour\n");
            this.logger.warn((Object)message);
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass();
        }
    }
}

