/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.json;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.boot.jackson.JsonComponent;
import org.springframework.boot.test.autoconfigure.filter.StandardAnnotationCustomizableTypeExcludeFilter;
import org.springframework.boot.test.autoconfigure.json.JsonTest;
import org.springframework.util.ClassUtils;

public final class JsonTypeExcludeFilter
extends StandardAnnotationCustomizableTypeExcludeFilter<JsonTest> {
    private static final String JACKSON_MODULE = "tools.jackson.databind.JacksonModule";
    private static final Set<Class<?>> DEFAULT_INCLUDES;

    JsonTypeExcludeFilter(Class<?> testClass) {
        super(testClass);
    }

    @Override
    protected Set<Class<?>> getDefaultIncludes() {
        return DEFAULT_INCLUDES;
    }

    static {
        LinkedHashSet<Class<JsonComponent>> includes = new LinkedHashSet<Class<JsonComponent>>();
        try {
            includes.add(ClassUtils.forName((String)JACKSON_MODULE, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        includes.add(JsonComponent.class);
        DEFAULT_INCLUDES = Collections.unmodifiableSet(includes);
    }
}

