/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionEvaluationReport;
import org.springframework.boot.autoconfigure.logging.ConditionEvaluationReportMessage;
import org.springframework.boot.test.context.DefaultTestExecutionListenersPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

public class SpringBootDependencyInjectionTestExecutionListener
extends DependencyInjectionTestExecutionListener {
    public void prepareTestInstance(TestContext testContext) throws Exception {
        try {
            super.prepareTestInstance(testContext);
        }
        catch (Exception ex) {
            this.outputConditionEvaluationReport(testContext);
            throw ex;
        }
    }

    private void outputConditionEvaluationReport(TestContext testContext) {
        try {
            ApplicationContext context = testContext.getApplicationContext();
            if (context instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)context;
                ConditionEvaluationReport report = ConditionEvaluationReport.get((ConfigurableListableBeanFactory)configurableContext.getBeanFactory());
                System.err.println(new ConditionEvaluationReportMessage(report));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static class PostProcessor
    implements DefaultTestExecutionListenersPostProcessor {
        PostProcessor() {
        }

        public List<TestExecutionListener> postProcessDefaultTestExecutionListeners(List<TestExecutionListener> listeners) {
            ArrayList<TestExecutionListener> updated = new ArrayList<TestExecutionListener>();
            for (TestExecutionListener listener : listeners) {
                updated.add((TestExecutionListener)(listener instanceof DependencyInjectionTestExecutionListener ? new SpringBootDependencyInjectionTestExecutionListener() : listener));
            }
            return updated;
        }
    }
}

