/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.session.hazelcast.autoconfigure;

import com.hazelcast.core.HazelcastInstance;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.hazelcast.autoconfigure.HazelcastAutoConfiguration;
import org.springframework.boot.session.autoconfigure.SessionAutoConfiguration;
import org.springframework.boot.session.autoconfigure.SessionProperties;
import org.springframework.boot.session.hazelcast.autoconfigure.HazelcastSessionProperties;
import org.springframework.boot.web.server.autoconfigure.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.session.Session;
import org.springframework.session.SessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.hazelcast.HazelcastIndexedSessionRepository;
import org.springframework.session.hazelcast.config.annotation.web.http.HazelcastHttpSessionConfiguration;

@AutoConfiguration(before={SessionAutoConfiguration.class}, after={HazelcastAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Session.class, HazelcastIndexedSessionRepository.class})
@ConditionalOnMissingBean(value={SessionRepository.class})
@ConditionalOnBean(value={HazelcastInstance.class})
@EnableConfigurationProperties(value={HazelcastSessionProperties.class, ServerProperties.class, SessionProperties.class})
@Import(value={HazelcastHttpSessionConfiguration.class})
public final class HazelcastSessionAutoConfiguration {
    @Bean
    @Order(value=-2147483648)
    SessionRepositoryCustomizer<HazelcastIndexedSessionRepository> springBootSessionRepositoryCustomizer(SessionProperties sessionProperties, HazelcastSessionProperties hazelcastSessionProperties, ServerProperties serverProperties) {
        return sessionRepository -> {
            PropertyMapper map = PropertyMapper.get();
            map.from((Object)sessionProperties.determineTimeout(() -> serverProperties.getServlet().getSession().getTimeout())).to(arg_0 -> ((HazelcastIndexedSessionRepository)sessionRepository).setDefaultMaxInactiveInterval(arg_0));
            map.from(hazelcastSessionProperties::getMapName).to(arg_0 -> ((HazelcastIndexedSessionRepository)sessionRepository).setSessionMapName(arg_0));
            map.from(hazelcastSessionProperties::getFlushMode).to(arg_0 -> ((HazelcastIndexedSessionRepository)sessionRepository).setFlushMode(arg_0));
            map.from(hazelcastSessionProperties::getSaveMode).to(arg_0 -> ((HazelcastIndexedSessionRepository)sessionRepository).setSaveMode(arg_0));
        };
    }
}

