/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.security.autoconfigure.actuate.web.servlet;

import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointAutoConfiguration;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.health.actuate.endpoint.HealthEndpoint;
import org.springframework.boot.security.autoconfigure.actuate.web.servlet.EndpointRequest;
import org.springframework.boot.security.autoconfigure.web.servlet.ConditionalOnDefaultWebSecurity;
import org.springframework.boot.security.autoconfigure.web.servlet.ServletWebSecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.ClassUtils;

@AutoConfiguration(before={ServletWebSecurityAutoConfiguration.class}, afterName={"org.springframework.boot.health.autoconfigure.actuate.endpoint.HealthEndpointAutoConfiguration", "org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={RequestMatcher.class, WebEndpointAutoConfiguration.class})
@ConditionalOnDefaultWebSecurity
public final class ManagementWebSecurityAutoConfiguration {
    @Bean
    @Order(value=0x7FFFFFFA)
    SecurityFilterChain managementSecurityFilterChain(Environment environment, HttpSecurity http) {
        if (ClassUtils.isPresent((String)"org.springframework.boot.health.actuate.endpoint.HealthEndpoint", (ClassLoader)this.getClass().getClassLoader())) {
            http.authorizeHttpRequests(requests -> {
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new RequestMatcher[]{this.healthMatcher(), this.additionalHealthPathsMatcher()})).permitAll();
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated();
            });
        }
        if (ClassUtils.isPresent((String)"org.springframework.web.servlet.DispatcherServlet", null)) {
            http.cors(Customizer.withDefaults());
        }
        http.formLogin(Customizer.withDefaults());
        http.httpBasic(Customizer.withDefaults());
        return (SecurityFilterChain)http.build();
    }

    private RequestMatcher healthMatcher() {
        return EndpointRequest.to(HealthEndpoint.class);
    }

    private RequestMatcher additionalHealthPathsMatcher() {
        return EndpointRequest.toAdditionalPaths(WebServerNamespace.SERVER, HealthEndpoint.class);
    }
}

